"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRegisterCustomizationProfile = exports.createProfileRegistry = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createProfileRegistry = () => {
  const profiles = new Map([['default', createProfile('default')]]);
  const profiles$ = new _rxjs.BehaviorSubject([...profiles.values()]);
  return {
    get: id => profiles.get(id.toLowerCase()),
    set: profile => {
      profiles.set(profile.id.toLowerCase(), profile);
      profiles$.next([...profiles.values()]);
    },
    getContributedAppState$() {
      return profiles$.pipe((0, _rxjs.map)(profilesList => profilesList.flatMap(profile => {
        var _profile$deepLinks;
        return (_profile$deepLinks = profile.deepLinks) !== null && _profile$deepLinks !== void 0 ? _profile$deepLinks : [];
      })), (0, _rxjs.map)(profilesDeepLinks => app => {
        var _app$deepLinks;
        return {
          deepLinks: getUniqueDeepLinks([...((_app$deepLinks = app.deepLinks) !== null && _app$deepLinks !== void 0 ? _app$deepLinks : []), ...profilesDeepLinks])
        };
      }));
    }
  };
};
exports.createProfileRegistry = createProfileRegistry;
const createRegisterCustomizationProfile = profileRegistry => (id, options) => {
  var _profileRegistry$get;
  const profile = (_profileRegistry$get = profileRegistry.get(id)) !== null && _profileRegistry$get !== void 0 ? _profileRegistry$get : createProfile(id);
  const {
    customize,
    deepLinks
  } = options;
  profile.customizationCallbacks.push(customize);
  if (Array.isArray(deepLinks) && profile.deepLinks) {
    profile.deepLinks = getUniqueDeepLinks([...profile.deepLinks, ...deepLinks]);
  } else if (Array.isArray(deepLinks)) {
    profile.deepLinks = getUniqueDeepLinks(deepLinks);
  }
  profileRegistry.set(profile);
};

/**
 * Utils
 */
exports.createRegisterCustomizationProfile = createRegisterCustomizationProfile;
const createProfile = id => ({
  id,
  customizationCallbacks: [],
  deepLinks: []
});
const getUniqueDeepLinks = deepLinks => {
  const mapValues = deepLinks.reduce((deepLinksMap, deepLink) => deepLinksMap.set(deepLink.id, deepLink), new Map()).values();
  return Array.from(mapValues);
};