"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _table_cell = require("./table_row/table_cell");
var _row_formatter = require("../utils/row_formatter");
var _table_row_details = require("./table_row_details");
var _use_discover_services = require("../../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TableRow = ({
  filters,
  isPlainRecord,
  columns,
  filter,
  savedSearchId,
  row,
  rows,
  dataView,
  useNewFieldsApi,
  shouldShowFieldHandler,
  onAddColumn,
  onRemoveColumn
}) => {
  const {
    uiSettings,
    fieldFormats
  } = (0, _use_discover_services.useDiscoverServices)();
  const [maxEntries, hideTimeColumn] = (0, _react.useMemo)(() => [uiSettings.get(_discoverUtils.MAX_DOC_FIELDS_DISPLAYED), uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false)], [uiSettings]);
  const [open, setOpen] = (0, _react.useState)(false);
  const docTableRowClassName = (0, _classnames.default)('kbnDocTable__row', {
    'kbnDocTable__row--highlight': row.isAnchor
  });
  const anchorDocTableRowSubj = row.isAnchor ? ' docTableAnchorRow' : '';
  const mapping = (0, _react.useMemo)(() => dataView.fields.getByName, [dataView]);

  // toggle display of the rows details, a full list of the fields from each row
  const toggleRow = () => setOpen(prevOpen => !prevOpen);

  /**
   * Fill an element with the value of a field
   */
  const displayField = fieldName => {
    // If we're formatting the _source column, don't use the regular field formatter,
    // but our Discover mechanism to format a hit in a better human-readable way.
    if (fieldName === '_source') {
      return (0, _row_formatter.formatRow)(row, dataView, shouldShowFieldHandler, maxEntries, fieldFormats);
    }
    const formattedField = (0, _discoverUtils.formatFieldValue)(row.flattened[fieldName], row.raw, fieldFormats, dataView, mapping(fieldName));
    return (
      /*#__PURE__*/
      // formatFieldValue always returns sanitized HTML
      // eslint-disable-next-line react/no-danger
      _react.default.createElement("div", {
        className: "dscTruncateByHeight",
        dangerouslySetInnerHTML: {
          __html: formattedField
        }
      })
    );
  };
  const inlineFilter = (0, _react.useCallback)((column, type) => {
    const field = dataView.fields.getByName(column);
    filter(field, row.flattened[column], type);
  }, [filter, dataView.fields, row.flattened]);
  const rowCells = [/*#__PURE__*/_react.default.createElement("td", {
    className: "kbnDocTableCell__toggleDetails",
    key: "toggleDetailsCell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleRow,
    size: "xs",
    "aria-expanded": open,
    "aria-label": _i18n.i18n.translate('discover.docTable.tableRow.toggleRowDetailsButtonAriaLabel', {
      defaultMessage: 'Toggle row details'
    }),
    "data-test-subj": "docTableExpandToggleColumn"
  }, open ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowDown",
    color: "text",
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowRight",
    color: "text",
    size: "s"
  })))];
  if (dataView.timeFieldName && !hideTimeColumn) {
    var _mapping;
    rowCells.push( /*#__PURE__*/_react.default.createElement(_table_cell.TableCell, {
      key: dataView.timeFieldName,
      timefield: true,
      formatted: displayField(dataView.timeFieldName),
      filterable: Boolean(((_mapping = mapping(dataView.timeFieldName)) === null || _mapping === void 0 ? void 0 : _mapping.filterable) && filter),
      column: dataView.timeFieldName,
      inlineFilter: inlineFilter
    }));
  }
  if (columns.length === 0 && useNewFieldsApi) {
    const formatted = (0, _row_formatter.formatRow)(row, dataView, shouldShowFieldHandler, maxEntries, fieldFormats);
    rowCells.push( /*#__PURE__*/_react.default.createElement(_table_cell.TableCell, {
      key: "__document__",
      timefield: false,
      sourcefield: true,
      formatted: formatted,
      filterable: false,
      column: "__document__",
      inlineFilter: inlineFilter
    }));
  } else {
    columns.forEach(function (column, index) {
      const cellKey = `${column}-${index}`;
      if (useNewFieldsApi && !mapping(column) && row.raw.fields && !row.raw.fields[column]) {
        const innerColumns = Object.fromEntries(Object.entries(row.raw.fields).filter(([key]) => {
          return key.indexOf(`${column}.`) === 0;
        }));
        rowCells.push( /*#__PURE__*/_react.default.createElement(_table_cell.TableCell, {
          key: cellKey,
          timefield: false,
          sourcefield: true,
          formatted: (0, _row_formatter.formatTopLevelObject)(row, innerColumns, dataView, maxEntries),
          filterable: false,
          column: column,
          inlineFilter: inlineFilter
        }));
      } else {
        var _mapping2, _row$raw$_ignored;
        // Check whether the field is defined as filterable in the mapping and does
        // NOT have ignored values in it to determine whether we want to allow filtering.
        // We should improve this and show a helpful tooltip why the filter buttons are not
        // there/disabled when there are ignored values.
        const isFilterable = Boolean(((_mapping2 = mapping(column)) === null || _mapping2 === void 0 ? void 0 : _mapping2.filterable) && typeof filter === 'function' && !((_row$raw$_ignored = row.raw._ignored) !== null && _row$raw$_ignored !== void 0 && _row$raw$_ignored.includes(column)));
        rowCells.push( /*#__PURE__*/_react.default.createElement(_table_cell.TableCell, {
          key: cellKey,
          timefield: false,
          sourcefield: column === '_source',
          formatted: displayField(column),
          filterable: isFilterable,
          column: column,
          inlineFilter: inlineFilter
        }));
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("tr", {
    "data-test-subj": `docTableRow${anchorDocTableRowSubj}`,
    className: docTableRowClassName
  }, rowCells), /*#__PURE__*/_react.default.createElement("tr", {
    "data-test-subj": "docTableDetailsRow",
    className: "kbnDocTableDetails__row"
  }, open && /*#__PURE__*/_react.default.createElement(_table_row_details.TableRowDetails, {
    colLength: (columns.length || 1) + 2,
    isTimeBased: dataView.isTimeBased(),
    dataView: dataView,
    rowIndex: row.raw._index,
    rowId: row.raw._id,
    columns: columns,
    filters: filters,
    savedSearchId: savedSearchId,
    isPlainRecord: isPlainRecord
  }, /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewer, {
    columns: columns,
    filter: filter,
    hit: row,
    dataView: dataView,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    textBasedHits: isPlainRecord ? rows : undefined
  }))));
};
exports.TableRow = TableRow;