"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridFlyout = DiscoverGridFlyout;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _use_discover_services = require("../../hooks/use_discover_services");
var _is_text_based_query = require("../../application/main/utils/is_text_based_query");
var _use_flyout_actions = require("./use_flyout_actions");
var _customizations = require("../../customizations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getIndexByDocId(hits, id) {
  return hits.findIndex(h => {
    return h.id === id;
  });
}
/**
 * Flyout displaying an expanded Elasticsearch document
 */
function DiscoverGridFlyout({
  hit,
  hits,
  dataView,
  columns,
  columnTypes,
  savedSearchId,
  filters,
  query,
  onFilter,
  onClose,
  onRemoveColumn,
  onAddColumn,
  setExpandedDoc
}) {
  var _flyoutCustomization$, _flyoutCustomization$2;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const flyoutCustomization = (0, _customizations.useDiscoverCustomization)('flyout');
  const isPlainRecord = (0, _is_text_based_query.isTextBasedQuery)(query);
  // Get actual hit with updated highlighted searches
  const actualHit = (0, _react.useMemo)(() => (hits === null || hits === void 0 ? void 0 : hits.find(({
    id
  }) => id === (hit === null || hit === void 0 ? void 0 : hit.id))) || hit, [hit, hits]);
  const pageCount = (0, _react.useMemo)(() => hits ? hits.length : 0, [hits]);
  const activePage = (0, _react.useMemo)(() => {
    const id = hit.id;
    if (!hits || pageCount <= 1) {
      return -1;
    }
    return getIndexByDocId(hits, id);
  }, [hits, hit, pageCount]);
  const setPage = (0, _react.useCallback)(index => {
    if (hits && hits[index]) {
      setExpandedDoc(hits[index]);
    }
  }, [hits, setExpandedDoc]);
  const onKeyDown = (0, _react.useCallback)(ev => {
    if (ev.key === _eui.keys.ARROW_LEFT || ev.key === _eui.keys.ARROW_RIGHT) {
      ev.preventDefault();
      ev.stopPropagation();
      setPage(activePage + (ev.key === _eui.keys.ARROW_RIGHT ? 1 : -1));
    }
  }, [activePage, setPage]);
  const {
    flyoutActions
  } = (0, _use_flyout_actions.useFlyoutActions)({
    actions: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.actions,
    dataView,
    rowIndex: hit.raw._index,
    rowId: hit.raw._id,
    columns,
    filters,
    savedSearchId
  });
  const addColumn = (0, _react.useCallback)(columnName => {
    onAddColumn(columnName);
    services.toastNotifications.addSuccess(_i18n.i18n.translate('discover.grid.flyout.toastColumnAdded', {
      defaultMessage: `Column '{columnName}' was added`,
      values: {
        columnName
      }
    }));
  }, [onAddColumn, services.toastNotifications]);
  const removeColumn = (0, _react.useCallback)(columnName => {
    onRemoveColumn(columnName);
    services.toastNotifications.addSuccess(_i18n.i18n.translate('discover.grid.flyout.toastColumnRemoved', {
      defaultMessage: `Column '{columnName}' was removed`,
      values: {
        columnName
      }
    }));
  }, [onRemoveColumn, services.toastNotifications]);
  const renderDefaultContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewer, {
    columns: columns,
    columnTypes: columnTypes,
    dataView: dataView,
    filter: onFilter,
    hit: actualHit,
    onAddColumn: addColumn,
    onRemoveColumn: removeColumn,
    textBasedHits: isPlainRecord ? hits : undefined
  }), [actualHit, addColumn, columns, columnTypes, dataView, hits, isPlainRecord, onFilter, removeColumn]);
  const contentActions = (0, _react.useMemo)(() => ({
    addFilter: onFilter,
    addColumn,
    removeColumn
  }), [onFilter, addColumn, removeColumn]);
  const bodyContent = flyoutCustomization !== null && flyoutCustomization !== void 0 && flyoutCustomization.Content ? /*#__PURE__*/_react.default.createElement(flyoutCustomization.Content, {
    actions: contentActions,
    doc: actualHit,
    renderDefaultContent: renderDefaultContent
  }) : renderDefaultContent();
  const defaultFlyoutTitle = isPlainRecord ? _i18n.i18n.translate('discover.grid.tableRow.textBasedDetailHeading', {
    defaultMessage: 'Expanded row'
  }) : _i18n.i18n.translate('discover.grid.tableRow.detailHeading', {
    defaultMessage: 'Expanded document'
  });
  const flyoutTitle = (_flyoutCustomization$ = flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.title) !== null && _flyoutCustomization$ !== void 0 ? _flyoutCustomization$ : defaultFlyoutTitle;
  const flyoutSize = (_flyoutCustomization$2 = flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.size) !== null && _flyoutCustomization$2 !== void 0 ? _flyoutCustomization$2 : 'm';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: flyoutSize,
    "data-test-subj": "docTableDetailsFlyout",
    onKeyDown: onKeyDown,
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    className: "unifiedDataTable__flyoutHeader",
    "data-test-subj": "docTableRowDetailsTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, flyoutTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, !isPlainRecord && flyoutActions.map(action => action.enabled && /*#__PURE__*/_react.default.createElement(action.Content, {
    key: action.id
  })), activePage !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `dscDocNavigationPage-${activePage}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('discover.grid.flyout.documentNavigation', {
      defaultMessage: 'Document navigation'
    }),
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: setPage,
    className: "unifiedDataTable__flyoutDocumentNavigation",
    compressed: true,
    "data-test-subj": "dscDocNavigation"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, bodyContent)));
}

// eslint-disable-next-line import/no-default-export
var _default = DiscoverGridFlyout;
exports.default = _default;