"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundRoute = NotFoundRoute;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../../kibana_services");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let bannerId;
function NotFoundRoute() {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    urlForwarding,
    core,
    history
  } = services;
  const currentLocation = history().location.pathname;
  (0, _react.useEffect)(() => {
    const path = window.location.hash.substr(1);
    (0, _kibana_services.getUrlTracker)().restorePreviousUrl();
    urlForwarding.navigateToLegacyKibanaUrl(path);
    const bannerMessage = _i18n.i18n.translate('discover.noMatchRoute.bannerTitleText', {
      defaultMessage: 'Page not found'
    });
    bannerId = core.overlays.banners.replace(bannerId, (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "iInCircle",
      title: bannerMessage
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "invalidRouteMessage"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noMatchRoute.bannerText",
      defaultMessage: "Discover application doesn't recognize this route: {route}",
      values: {
        route: history().location.state.referrer
      }
    }))), {
      theme: core.theme,
      i18n: core.i18n
    }));

    // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
    setTimeout(() => {
      if (bannerId) {
        core.overlays.banners.remove(bannerId);
      }
    }, 15000);
  }, [core, history, urlForwarding]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: '/',
      state: {
        referrer: currentLocation
      }
    }
  });
}