"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewByTextBasedQueryLang = getDataViewByTextBasedQueryLang;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function getDataViewByTextBasedQueryLang(query, currentDataView, services) {
  let indexPatternFromQuery = '';
  if ('sql' in query) {
    indexPatternFromQuery = (0, _esQuery.getIndexPatternFromSQLQuery)(query.sql);
  }
  if ('esql' in query) {
    indexPatternFromQuery = (0, _esQuery.getIndexPatternFromESQLQuery)(query.esql);
  }
  // we should find a better way to work with ESQL queries which dont need a dataview
  if (!indexPatternFromQuery && currentDataView) return currentDataView;
  if (currentDataView !== null && currentDataView !== void 0 && currentDataView.isPersisted() || indexPatternFromQuery !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern())) {
    var _dataViewObj$fields$g;
    const dataViewObj = await services.dataViews.create({
      title: indexPatternFromQuery
    });
    if (((_dataViewObj$fields$g = dataViewObj.fields.getByName('@timestamp')) === null || _dataViewObj$fields$g === void 0 ? void 0 : _dataViewObj$fields$g.type) === 'date') {
      dataViewObj.timeFieldName = '@timestamp';
    }
    return dataViewObj;
  }
  return currentDataView;
}