"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityTable = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../common/translations");
var _columns = require("../components/dataset_quality/columns");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SORT_FIELD = 'title';
const DEFAULT_SORT_DIRECTION = 'desc';
const sortingOverrides = {
  ['size']: 'sizeBytes'
};
const useDatasetQualityTable = () => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const defaultTimeRange = (0, _utils.getDefaultTimeRange)();
  const {
    dataStreamsStatsServiceClient: client
  } = (0, _context.useDatasetQualityContext)();
  const {
    data = [],
    loading
  } = (0, _public.useFetcher)(async () => client.getDataStreamsStats(), []);
  const {
    data: malformedStats = [],
    loading: loadingMalformedStats
  } = (0, _public.useFetcher)(async () => client.getDataStreamsMalformedStats({
    start: defaultTimeRange.from,
    end: defaultTimeRange.to
  }), []);
  const columns = (0, _react.useMemo)(() => (0, _columns.getDatasetQualitTableColumns)({
    fieldFormats,
    loadingMalformedStats
  }), [fieldFormats, loadingMalformedStats]);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: data.length,
    hidePerPageOptions: true
  };
  const onTableChange = (0, _react.useCallback)(options => {
    var _options$sort, _options$sort2;
    setPageIndex(options.page.index);
    setPageSize(options.page.size);
    setSortField(((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || DEFAULT_SORT_FIELD);
    setSortDirection(((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || DEFAULT_SORT_DIRECTION);
  }, []);
  const sort = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const renderedItems = (0, _react.useMemo)(() => {
    const overridenSortingField = sortingOverrides[sortField] || sortField;
    const mergedData = data.map(dataStream => {
      const malformedDocs = (0, _lodash.find)(malformedStats, {
        dataset: dataStream.name
      });
      return {
        ...dataStream,
        malformedDocs: malformedDocs === null || malformedDocs === void 0 ? void 0 : malformedDocs.percentage
      };
    });
    const sortedItems = (0, _lodash.orderBy)(mergedData, overridenSortingField, sortDirection);
    return sortedItems.slice(pageIndex * pageSize, (pageIndex + 1) * pageSize);
  }, [data, malformedStats, sortField, sortDirection, pageIndex, pageSize]);
  const resultsCount = (0, _react.useMemo)(() => {
    const startNumberItemsOnPage = pageSize * pageIndex + (renderedItems.length ? 1 : 0);
    const endNumberItemsOnPage = pageSize * pageIndex + renderedItems.length;
    return pageSize === 0 ? /*#__PURE__*/_react.default.createElement("strong", null, _translations.tableSummaryAllText) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, startNumberItemsOnPage, "-", endNumberItemsOnPage), ' ', _translations.tableSummaryOfText, " ", data.length);
  }, [data.length, pageIndex, pageSize, renderedItems.length]);
  return {
    sort,
    onTableChange,
    pagination,
    renderedItems,
    columns,
    loading,
    resultsCount
  };
};
exports.useDatasetQualityTable = useDatasetQualityTable;