"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityPercentageIndicator = QualityPercentageIndicator;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _indicator = require("./indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QualityPercentageIndicator({
  percentage
}) {
  if ((0, _lodash.isNil)(percentage)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const quality = percentage > _constants.POOR_QUALITY_MINIMUM_PERCENTAGE ? 'poor' : percentage > _constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE ? 'degraded' : 'good';
  return /*#__PURE__*/_react.default.createElement(_indicator.QualityIndicator, {
    quality: quality
  });
}