"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.malformedDocsRt = exports.integrationRt = exports.integrationIconRt = exports.getDataStreamsStatsResponseRt = exports.getDataStreamsMalformedDocsStatsResponseRt = exports.datasetStatRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const datasetStatRt = rt.intersection([rt.type({
  name: rt.string
}), rt.partial({
  size: rt.string,
  sizeBytes: rt.number,
  lastActivity: rt.number,
  integration: rt.string
})]);
exports.datasetStatRt = datasetStatRt;
const integrationIconRt = rt.intersection([rt.type({
  path: rt.string,
  src: rt.string
}), rt.partial({
  title: rt.string,
  size: rt.string,
  type: rt.string
})]);
exports.integrationIconRt = integrationIconRt;
const integrationRt = rt.intersection([rt.type({
  name: rt.string
}), rt.partial({
  title: rt.string,
  version: rt.string,
  icons: rt.array(integrationIconRt)
})]);
exports.integrationRt = integrationRt;
const malformedDocsRt = rt.type({
  dataset: rt.string,
  percentage: rt.number
});
exports.malformedDocsRt = malformedDocsRt;
const getDataStreamsStatsResponseRt = rt.exact(rt.intersection([rt.type({
  dataStreamsStats: rt.array(datasetStatRt)
}), rt.type({
  integrations: rt.array(integrationRt)
})]));
exports.getDataStreamsStatsResponseRt = getDataStreamsStatsResponseRt;
const getDataStreamsMalformedDocsStatsResponseRt = rt.exact(rt.type({
  malformedDocs: rt.array(malformedDocsRt)
}));
exports.getDataStreamsMalformedDocsStatsResponseRt = getDataStreamsMalformedDocsStatsResponseRt;