"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsStats = void 0;
var _constants = require("../../../../../common/constants");
var _get_date_field_stats = require("./get_date_field_stats");
var _get_boolean_field_stats = require("./get_boolean_field_stats");
var _get_field_examples = require("./get_field_examples");
var _get_numeric_field_stats = require("./get_numeric_field_stats");
var _get_string_field_stats = require("./get_string_field_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldsStats = (dataSearch, params, fields, options) => {
  const fieldType = fields[0].type;
  switch (fieldType) {
    case _constants.SUPPORTED_FIELD_TYPES.NUMBER:
      return (0, _get_numeric_field_stats.fetchNumericFieldsStats)(dataSearch, params, fields, options);
    case _constants.SUPPORTED_FIELD_TYPES.KEYWORD:
    case _constants.SUPPORTED_FIELD_TYPES.IP:
    case _constants.SUPPORTED_FIELD_TYPES.VERSION:
      return (0, _get_string_field_stats.fetchStringFieldsStats)(dataSearch, params, fields, options);
    case _constants.SUPPORTED_FIELD_TYPES.DATE:
      return (0, _get_date_field_stats.fetchDateFieldsStats)(dataSearch, params, fields, options);
    case _constants.SUPPORTED_FIELD_TYPES.BOOLEAN:
      return (0, _get_boolean_field_stats.fetchBooleanFieldsStats)(dataSearch, params, fields, options);
    case _constants.SUPPORTED_FIELD_TYPES.TEXT:
      return (0, _get_field_examples.fetchFieldsExamples)(dataSearch, params, fields, options);
    default:
      // Use an exists filter on the the field name to get
      // examples of the field, so cannot batch up.
      return (0, _get_field_examples.fetchFieldsExamples)(dataSearch, params, fields, options);
  }
};
exports.getFieldsStats = getFieldsStats;