"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataVisualizerViewWrapper = exports.EmbeddableWrapper = exports.DataVisualizerGridEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _constants = require("./constants");
var _embeddable_loading_fallback = require("./embeddable_loading_fallback");
var _stats_table = require("../../../common/components/stats_table");
var _index_data_visualizer_view = require("../../components/index_data_visualizer_view/index_data_visualizer_view");
var _index_based_expanded_row = require("../../../common/components/expanded_row/index_based_expanded_row");
var _use_data_visualizer_grid_data = require("../../hooks/use_data_visualizer_grid_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const restorableDefaults = (0, _index_data_visualizer_view.getDefaultDataVisualizerListState)();
const EmbeddableWrapper = ({
  input,
  onOutputChange
}) => {
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _react.useState)(restorableDefaults);
  const onTableChange = (0, _react.useCallback)(update => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      ...update
    });
    if (onOutputChange) {
      onOutputChange(update);
    }
  }, [dataVisualizerListState, onOutputChange]);
  const {
    configs,
    searchQueryLanguage,
    searchString,
    extendedColumns,
    progress,
    overallStatsProgress,
    setLastRefresh
  } = (0, _use_data_visualizer_grid_data.useDataVisualizerGridData)(input, dataVisualizerListState);
  (0, _react.useEffect)(() => {
    setLastRefresh(Date.now());
  }, [input === null || input === void 0 ? void 0 : input.lastReloadRequestTime, setLastRefresh]);
  const getItemIdToExpandedRowMap = (0, _react.useCallback)(function (itemIds, items) {
    return itemIds.reduce((m, fieldName) => {
      const item = items.find(fieldVisConfig => fieldVisConfig.fieldName === fieldName);
      if (item !== undefined) {
        m[fieldName] = /*#__PURE__*/_react.default.createElement(_index_based_expanded_row.IndexBasedDataVisualizerExpandedRow, {
          item: item,
          dataView: input.dataView,
          combinedQuery: {
            searchQueryLanguage,
            searchString
          },
          onAddFilter: input.onAddFilter,
          totalDocuments: input.totalDocuments
        });
      }
      return m;
    }, {});
  }, [input, searchQueryLanguage, searchString]);
  if (progress === 100 && configs.length === 0) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        flex: '1 0 100%',
        textAlign: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "m",
      color: "subdued"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.index.embeddableNoResultsMessage",
      defaultMessage: "No results found"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_stats_table.DataVisualizerTable, {
    items: configs,
    pageState: dataVisualizerListState,
    updatePageState: onTableChange,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    extendedColumns: extendedColumns,
    showPreviewByDefault: input === null || input === void 0 ? void 0 : input.showPreviewByDefault,
    onChange: onOutputChange,
    loading: progress < 100,
    overallStatsRunning: overallStatsProgress.isRunning
  });
};
exports.EmbeddableWrapper = EmbeddableWrapper;
const IndexDataVisualizerViewWrapper = props => {
  const {
    embeddableInput,
    onOutputChange
  } = props;
  const input = (0, _useObservable.default)(embeddableInput);
  if (input && input.dataView) {
    return /*#__PURE__*/_react.default.createElement(EmbeddableWrapper, {
      input: input,
      onOutputChange: onOutputChange
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorTitle",
        defaultMessage: "Error loading embeddable"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorDescription",
        defaultMessage: "There was an error loading the embeddable. Please check if all the required input is valid."
      }))
    });
  }
};
exports.IndexDataVisualizerViewWrapper = IndexDataVisualizerViewWrapper;
class DataVisualizerGridEmbeddable extends _public.Embeddable {
  constructor(initialInput, services, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "type", _constants.DATA_VISUALIZER_GRID_EMBEDDABLE_TYPE);
    this.services = services;
  }
  render(node) {
    super.render(node);
    this.node = node;
    const I18nContext = this.services[0].i18n.Context;
    const services = {
      ...this.services[0],
      ...this.services[1]
    };
    const datePickerDeps = {
      ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
      uiSettingsKeys: _common.UI_SETTINGS
    };
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: this.services[0].theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: services
    }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_embeddable_loading_fallback.EmbeddableLoading, null)
    }, /*#__PURE__*/_react.default.createElement(IndexDataVisualizerViewWrapper, {
      id: this.input.id,
      embeddableContext: this,
      embeddableInput: this.getInput$(),
      onOutputChange: output => this.updateOutput(output)
    })))))), node);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {
    this.reload$.next();
  }
  supportedTriggers() {
    return [];
  }
}
exports.DataVisualizerGridEmbeddable = DataVisualizerGridEmbeddable;