"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _search_bar = require("./search_bar");
var _field_name_filter = require("./field_name_filter");
var _field_type_filter = require("./field_type_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchPanel = ({
  dataView,
  searchString,
  searchQuery,
  searchQueryLanguage,
  overallStats,
  indexedFieldTypes,
  setVisibleFieldTypes,
  visibleFieldTypes,
  setVisibleFieldNames,
  visibleFieldNames,
  setSearchParams,
  showEmptyFields
}) => {
  const dvSearchPanelControls = (0, _react2.css)({
    marginLeft: '0px !important',
    paddingLeft: '0px !important',
    paddingRight: '0px !important',
    flexDirection: 'row',
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      padding: 0
    }
  });
  const dvSearchPanelContainer = (0, _react2.css)({
    alignItems: 'baseline',
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      flexDirection: 'column'
    }
  });
  const dvSearchBar = (0, _react2.css)({
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      minWidth: `max(100%, 300px)`
    }
  });
  const isWithinXl = (0, _eui.useIsWithinMaxBreakpoint)('xl');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "dataVisualizerSearchPanel",
    css: dvSearchPanelContainer,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    css: dvSearchBar
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchPanelContent, {
    dataView: dataView,
    setSearchParams: setSearchParams,
    searchString: searchString,
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage
  })), isWithinXl ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: dvSearchPanelControls
  }, /*#__PURE__*/_react.default.createElement(_field_name_filter.DataVisualizerFieldNamesFilter, {
    overallStats: overallStats,
    setVisibleFieldNames: setVisibleFieldNames,
    visibleFieldNames: visibleFieldNames,
    showEmptyFields: showEmptyFields
  }), /*#__PURE__*/_react.default.createElement(_field_type_filter.DataVisualizerFieldTypeFilter, {
    indexedFieldTypes: indexedFieldTypes,
    setVisibleFieldTypes: setVisibleFieldTypes,
    visibleFieldTypes: visibleFieldTypes
  })));
};
exports.SearchPanel = SearchPanel;