"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerFieldNamesFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _multi_select_picker = require("../../../common/components/multi_select_picker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataVisualizerFieldNamesFilter = ({
  overallStats,
  setVisibleFieldNames,
  visibleFieldNames,
  showEmptyFields
}) => {
  const items = (0, _react.useMemo)(() => {
    const options = [];
    if (overallStats) {
      Object.keys(overallStats).forEach(key => {
        const fieldsGroup = overallStats[key];
        if (Array.isArray(fieldsGroup) && fieldsGroup.length > 0) {
          fieldsGroup.forEach(field => {
            if ((field.existsInDocs === true || showEmptyFields === true) && field.fieldName !== undefined) {
              options.push({
                value: field.fieldName
              });
            } else {
              options.push({
                value: field.fieldName,
                disabled: true
              });
            }
          });
        }
      });
    }
    return options;
  }, [overallStats, showEmptyFields]);
  const fieldNameTitle = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.dataVisualizer.index.fieldNameSelect', {
    defaultMessage: 'Field name'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_multi_select_picker.MultiSelectPicker, {
    title: fieldNameTitle,
    options: items,
    onChange: setVisibleFieldNames,
    checkedOptions: visibleFieldNames,
    dataTestSubj: 'dataVisualizerFieldNameSelect'
  });
};
exports.DataVisualizerFieldNamesFilter = DataVisualizerFieldNamesFilter;