"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataDriftStateManager = exports.defaultSearchQuery = exports.DataDriftStateManagerContext = void 0;
exports.useDataDriftStateManagerContext = useDataDriftStateManagerContext;
var _react = require("react");
var _mlRandomSamplerUtils = require("@kbn/ml-random-sampler-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSearchQuery = {
  match_all: {}
};
exports.defaultSearchQuery = defaultSearchQuery;
const DataDriftStateManagerContext = /*#__PURE__*/(0, _react.createContext)({
  get dataView() {
    throw new Error('DataDriftStateManagerContext is not implemented');
  },
  get reference() {
    throw new Error('reference is not implemented');
  },
  get comparison() {
    throw new Error('comparison is not implemented');
  }
});
exports.DataDriftStateManagerContext = DataDriftStateManagerContext;
const useDataDriftStateManager = ({
  id,
  indexPattern: initialIndexPattern,
  searchString: initialSearchString,
  searchQuery: initialSearchQuery,
  searchQueryLanguage: initialSearchQueryLanguage,
  filters: initialFilters,
  timeField: initialTimeField
}) => {
  const [query, setQuery] = (0, _react.useState)(initialSearchQuery);
  const [indexPattern, setIndexPattern] = (0, _react.useState)(initialIndexPattern);
  const [searchString, setSearchString] = (0, _react.useState)(initialSearchString);
  const [searchQueryLanguage, setSearchQueryLanguage] = (0, _react.useState)(initialSearchQueryLanguage);
  const [filters, setFilters] = (0, _react.useState)(initialFilters);
  const [timeField, setTimeField] = (0, _react.useState)(initialTimeField);
  const [randomSampler] = (0, _react.useState)(new _mlRandomSamplerUtils.RandomSampler());
  return {
    id,
    query,
    setQuery,
    indexPattern,
    setIndexPattern,
    searchString,
    setSearchString,
    searchQueryLanguage,
    setSearchQueryLanguage,
    filters,
    setFilters,
    timeField,
    setTimeField,
    randomSampler
  };
};
exports.useDataDriftStateManager = useDataDriftStateManager;
function useDataDriftStateManagerContext() {
  return (0, _react.useContext)(DataDriftStateManagerContext);
}