"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftDistributionChart = void 0;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/field-formats-plugin/common");
var _i18n = require("@kbn/i18n");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _eui = require("@elastic/eui");
var _no_charts_data = require("./no_charts_data");
var _constants = require("../constants");
var _data_drift_chart_tooltip_body = require("../data_drift_chart_tooltip_body");
var _default_value_formatter = require("./default_value_formatter");
var _storage = require("../../index_data_visualizer/types/storage");
var _data_drift = require("../../index_data_visualizer/types/data_drift");
var _use_current_eui_theme = require("../../common/hooks/use_current_eui_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_HEIGHT = 200;
const showAsAreaChartOption = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.showAsAreaChartOptionLabel', {
  defaultMessage: 'Show as area chart'
});
const showAsBarChartOption = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.showAsBarChartOptionLabel', {
  defaultMessage: 'Show as bar chart'
});
const visualizeComparisonChartType = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.visualizeComparisonTypeLabel', {
  defaultMessage: 'Visualize comparison type'
});
const visualizeComparisonChartIcons = [{
  id: _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.AREA,
  label: showAsAreaChartOption,
  iconType: 'visArea'
}, {
  id: _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.BAR,
  label: showAsBarChartOption,
  iconType: 'visBarVertical'
}];
const DataDriftDistributionChart = ({
  item,
  colors,
  secondaryType
}) => {
  const euiTheme = (0, _use_current_eui_theme.useCurrentEuiTheme)();
  const xAxisFormatter = (0, _default_value_formatter.useFieldFormatter)((0, _default_value_formatter.getFieldFormatType)(secondaryType));
  const yAxisFormatter = (0, _default_value_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.NUMBER);
  const [comparisonChartType, setComparisonChartType] = (0, _mlLocalStorage.useStorage)(_storage.DV_DATA_DRIFT_DISTRIBUTION_CHART_TYPE,
  // By default we will set default comparison chart in expanded row as area chart
  _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.AREA);
  if (!item || item.comparisonDistribution.length === 0) return /*#__PURE__*/_react.default.createElement(_no_charts_data.NoChartsData, null);
  const {
    featureName,
    fieldType,
    comparisonDistribution: data
  } = item;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%',
      height: `calc(${CHART_HEIGHT}px + ${euiTheme.euiSize});`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: visualizeComparisonChartType,
    options: visualizeComparisonChartIcons,
    idSelected: comparisonChartType,
    onChange: id => setComparisonChartType(id),
    isIconOnly: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    body: _data_drift_chart_tooltip_body.DataComparisonChartTooltipBody
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: xAxisFormatter,
    labelFormat: xAxisFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "vertical",
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: {
      min: 0,
      max: 1
    }
  }), comparisonChartType === _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.BAR ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "dataVisualizer.barDistributionComparisonChart",
    name: featureName,
    xScaleType: fieldType === _constants.DATA_COMPARISON_TYPE.NUMERIC ? _charts.ScaleType.Linear : _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['percentage'],
    splitSeriesAccessors: ['g'],
    data: data,
    color: identifier => {
      const key = identifier.seriesKeys[0];
      return key === _constants.COMPARISON_LABEL ? colors.comparisonColor : colors.referenceColor;
    }
  }) : /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "dataVisualizer.overlapDistributionComparisonChart",
    name: _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.distributionComparisonChartName', {
      defaultMessage: 'Distribution comparison of {referenceLabel} and {comparisonLabel} data for {fieldName}',
      values: {
        referenceLabel: _constants.REFERENCE_LABEL.toLowerCase(),
        comparisonLabel: _constants.COMPARISON_LABEL.toLowerCase(),
        fieldName: featureName
      }
    }),
    xScaleType: fieldType === _constants.DATA_COMPARISON_TYPE.NUMERIC ? _charts.ScaleType.Linear : _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['percentage'],
    splitSeriesAccessors: ['g'],
    data: data,
    curve: _charts.CurveType.CURVE_STEP,
    color: identifier => {
      const key = identifier.seriesKeys[0];
      return key === _constants.COMPARISON_LABEL ? colors.comparisonColor : colors.referenceColor;
    }
  })));
};
exports.DataDriftDistributionChart = DataDriftDistributionChart;