"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeywordContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _top_values = require("../../../top_values");
var _kibana_context = require("../../../../../kibana_context");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _choropleth_map = require("./choropleth_map");
var _error_message = require("./error_message");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KeywordContent = ({
  config,
  onAddFilter
}) => {
  var _config$stats, _config$stats2;
  const [EMSSuggestion, setEMSSuggestion] = (0, _react.useState)();
  const {
    stats,
    fieldName
  } = config;
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  const {
    services: {
      maps: mapsPlugin
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const loadEMSTermSuggestions = (0, _react.useCallback)(async () => {
    if (!mapsPlugin) return;
    const suggestion = await mapsPlugin.suggestEMSTermJoinConfig({
      sampleValues: Array.isArray(stats === null || stats === void 0 ? void 0 : stats.topValues) ? stats === null || stats === void 0 ? void 0 : stats.topValues.map(value => value.key) : [],
      sampleValuesColumnName: fieldName || ''
    });
    setEMSSuggestion(suggestion);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fieldName]);
  (0, _react.useEffect)(function getInitialEMSTermSuggestion() {
    loadEMSTermSuggestions();
  }, [loadEMSTermSuggestions]);
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerKeywordContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), (_config$stats = config.stats) !== null && _config$stats !== void 0 && _config$stats.error && fieldName !== undefined ? /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessageContent, {
    fieldName: fieldName,
    error: (_config$stats2 = config.stats) === null || _config$stats2 === void 0 ? void 0 : _config$stats2.error
  }) : null, /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: stats,
    fieldFormat: fieldFormat,
    barColor: "success",
    onAddFilter: onAddFilter
  }), EMSSuggestion && stats && /*#__PURE__*/_react.default.createElement(_choropleth_map.ChoroplethMap, {
    stats: stats,
    suggestion: EMSSuggestion
  }));
};
exports.KeywordContent = KeywordContent;