"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointContent = exports.DEFAULT_GEO_REGEX = void 0;
var _react = _interopRequireWildcard(require("react"));
var _document_stats = require("../../stats_table/components/field_data_expanded_row/document_stats");
var _embedded_map = require("../../embedded_map");
var _format_utils = require("./format_utils");
var _expanded_row_content = require("../../stats_table/components/field_data_expanded_row/expanded_row_content");
var _examples_list = require("../../examples_list");
var _expanded_row_panel = require("../../stats_table/components/field_data_expanded_row/expanded_row_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_GEO_REGEX = RegExp('(?<lat>.+) (?<lon>.+)');
exports.DEFAULT_GEO_REGEX = DEFAULT_GEO_REGEX;
const GeoPointContent = ({
  config
}) => {
  const formattedResults = (0, _react.useMemo)(() => {
    const {
      stats
    } = config;
    if (stats === undefined || stats.topValues === undefined) return null;
    if (Array.isArray(stats.topValues)) {
      const geoPointsFeatures = [];

      // reformatting the top values from POINT (-2.359207 51.37837) to (-2.359207, 51.37837)
      const formattedExamples = [];
      for (let i = 0; i < stats.topValues.length; i++) {
        const value = stats.topValues[i];
        const coordinates = (0, _format_utils.convertWKTGeoToLonLat)(value.key);
        if (coordinates) {
          const formattedGeoPoint = `(${coordinates.lat}, ${coordinates.lon})`;
          formattedExamples.push(coordinates);
          geoPointsFeatures.push({
            type: 'Feature',
            id: `fileDataVisualizer-${config.fieldName}-${i}`,
            geometry: {
              type: 'Point',
              coordinates: [coordinates.lat, coordinates.lon]
            },
            properties: {
              value: formattedGeoPoint,
              count: value.doc_count
            }
          });
        }
      }
      if (geoPointsFeatures.length > 0) {
        return {
          examples: formattedExamples,
          layerList: [(0, _format_utils.getGeoPointsLayer)(geoPointsFeatures)]
        };
      }
    }
  }, [config]);
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerGeoPointContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), formattedResults && Array.isArray(formattedResults.examples) && /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: formattedResults.examples
  }), formattedResults && Array.isArray(formattedResults.layerList) && /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvMap__wrapper',
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_embedded_map.EmbeddedMapComponent, {
    layerList: formattedResults.layerList
  })));
};
exports.GeoPointContent = GeoPointContent;