"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _random_sampler = require("../../../index_data_visualizer/constants/random_sampler");
var _total_count_header = require("./total_count_header");
var _document_count_chart = require("./document_count_chart");
var _random_sampler_range_slider = require("../random_sampling_menu/random_sampler_range_slider");
var _probability_used = require("../random_sampling_menu/probability_used");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CalculatingProbabilityMessage = /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "dvRandomSamplerCalculatingProbabilityMsg"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.dataVisualizer.randomSamplerSettingsPopUp.calculatingProbabilityLabel",
  defaultMessage: "Calculating the optimal probability"
}));
const DocumentCountContent = ({
  documentCountStats,
  totalCount,
  samplingProbability,
  setSamplingProbability,
  loading,
  randomSamplerPreference,
  setRandomSamplerPreference
}) => {
  const [showSamplingOptionsPopover, setShowSamplingOptionsPopover] = (0, _react.useState)(false);
  const onShowSamplingOptions = (0, _react.useCallback)(() => {
    setShowSamplingOptionsPopover(!showSamplingOptionsPopover);
  }, [showSamplingOptionsPopover]);
  const closeSamplingOptions = (0, _react.useCallback)(() => {
    setShowSamplingOptionsPopover(false);
  }, [setShowSamplingOptionsPopover]);
  const calloutInfoMessage = (0, _react.useMemo)(() => {
    switch (randomSamplerPreference) {
      case _random_sampler.RANDOM_SAMPLER_OPTION.OFF:
        return _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.offCalloutMessage', {
          defaultMessage: 'Random sampling can be turned on for the total document count and chart to increase speed although some accuracy will be lost.'
        });
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC:
        return _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onAutomaticCalloutMessage', {
          defaultMessage: 'The total document count and chart use random sampler aggregations. The probability is automatically set to balance accuracy and speed.'
        });
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL:
      default:
        return _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onManualCalloutMessage', {
          defaultMessage: 'The total document count and chart use random sampler aggregations. A lower percentage probability increases performance, but some accuracy is lost.'
        });
    }
  }, [randomSamplerPreference]);
  if (documentCountStats === undefined) {
    return totalCount !== undefined ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount
    }) : null;
  }
  const {
    timeRangeEarliest,
    timeRangeLatest
  } = documentCountStats;
  if (timeRangeEarliest === undefined || timeRangeLatest === undefined) return /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount
  });
  let chartPoints = [];
  if (documentCountStats.buckets !== undefined) {
    const buckets = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.buckets;
    chartPoints = Object.entries(buckets).map(([time, value]) => ({
      time: +time,
      value
    }));
  }
  const approximate = documentCountStats.randomlySampled === true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    approximate: approximate,
    loading: loading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "dvRandomSamplerOptionsPopover",
    id: "dataVisualizerSamplingOptions",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.dataVisualizer.samplingOptionsButton', {
        defaultMessage: 'Sampling options'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "xs",
      iconType: "gear",
      onClick: onShowSamplingOptions,
      "data-test-subj": "dvRandomSamplerOptionsButton",
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.samplingOptionsButton', {
        defaultMessage: 'Sampling options'
      })
    })),
    isOpen: showSamplingOptionsPopover,
    closePopover: closeSamplingOptions,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      maxWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: 'primary',
    title: calloutInfoMessage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "dvRandomSamplerOptionsFormRow",
    label: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.randomSamplerRowLabel', {
      defaultMessage: 'Random sampling'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "dvRandomSamplerOptionsSelect",
    options: _random_sampler.RANDOM_SAMPLER_SELECT_OPTIONS,
    value: randomSamplerPreference,
    onChange: e => setRandomSamplerPreference(e.target.value)
  })), randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL ? /*#__PURE__*/_react.default.createElement(_random_sampler_range_slider.RandomSamplerRangeSlider, {
    samplingProbability: samplingProbability,
    setSamplingProbability: setSamplingProbability
  }) : null, randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC ? loading ? CalculatingProbabilityMessage : /*#__PURE__*/_react.default.createElement(_probability_used.ProbabilityUsedMessage, {
    samplingProbability: samplingProbability
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))), /*#__PURE__*/_react.default.createElement(_document_count_chart.DocumentCountChart, {
    chartPoints: chartPoints,
    timeRangeEarliest: timeRangeEarliest,
    timeRangeLatest: timeRangeLatest,
    interval: documentCountStats.interval,
    loading: loading
  }));
};
exports.DocumentCountContent = DocumentCountContent;