"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const filterHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.filterHeader', {
  defaultMessage: 'Filter'
});
const filterDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.filterDescription', {
  defaultMessage: 'Filter name'
});
const matchesHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.matchesHeader', {
  defaultMessage: 'Matches'
});
const matchesDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.matchesDescription', {
  defaultMessage: 'Language used for the field'
});
const editAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.editAria', {
  defaultMessage: 'Edit'
});
const saveAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.saveAria', {
  defaultMessage: 'Save'
});
const deleteAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.deleteAria', {
  defaultMessage: 'Delete'
});
const cancelAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.cancelAria', {
  defaultMessage: 'Cancel'
});
class Table extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "startEditingFilter", (editingFilterId, editingFilterValue) => this.setState({
      editingFilterId,
      editingFilterValue
    }));
    (0, _defineProperty2.default)(this, "stopEditingFilter", () => this.setState({
      editingFilterId: ''
    }));
    (0, _defineProperty2.default)(this, "onEditingFilterChange", e => this.setState({
      editingFilterValue: e.target.value
    }));
    (0, _defineProperty2.default)(this, "onEditFieldKeyDown", ({
      key
    }) => {
      if (_eui.keys.ENTER === key && this.state.editingFilterId && this.state.editingFilterValue) {
        this.props.saveFilter({
          clientId: this.state.editingFilterId,
          value: this.state.editingFilterValue
        });
        this.stopEditingFilter();
      }
      if (_eui.keys.ESCAPE === key) {
        this.stopEditingFilter();
      }
    });
    this.state = {
      editingFilterId: '',
      editingFilterValue: ''
    };
  }
  getColumns() {
    const {
      deleteFilter,
      fieldWildcardMatcher,
      indexPattern,
      saveFilter
    } = this.props;
    return [{
      field: 'value',
      name: filterHeader,
      description: filterDescription,
      dataType: 'string',
      sortable: true,
      render: (value, filter) => {
        if (this.state.editingFilterId && this.state.editingFilterId === filter.clientId) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
            autoFocus: true,
            value: this.state.editingFilterValue,
            onChange: this.onEditingFilterChange,
            onKeyDown: this.onEditFieldKeyDown,
            "data-test-subj": `filter_input_${value}`
          });
        }
        return /*#__PURE__*/_react.default.createElement("span", null, value);
      }
    }, {
      field: 'value',
      name: matchesHeader,
      description: matchesDescription,
      dataType: 'string',
      sortable: true,
      render: (value, filter) => {
        const wildcardMatcher = fieldWildcardMatcher([this.state.editingFilterId === filter.clientId ? this.state.editingFilterValue : value]);
        const matches = indexPattern.getNonScriptedFields().map(currentFilter => currentFilter.name).filter(wildcardMatcher).sort();
        if (matches.length) {
          return /*#__PURE__*/_react.default.createElement("span", null, matches.join(', '));
        }
        return /*#__PURE__*/_react.default.createElement("em", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternManagement.editIndexPattern.source.table.notMatchedLabel",
          defaultMessage: "The source filter doesn't match any known fields."
        }));
      }
    }, {
      name: '',
      align: _eui.RIGHT_ALIGNMENT,
      width: '100',
      render: filter => {
        if (this.state.editingFilterId === filter.clientId) {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            size: "s",
            onClick: () => {
              saveFilter({
                clientId: this.state.editingFilterId,
                value: this.state.editingFilterValue
              });
              this.stopEditingFilter();
            },
            iconType: "checkInCircleFilled",
            "aria-label": saveAria,
            "data-test-subj": `save_filter-${filter.value}`
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            size: "s",
            onClick: () => {
              this.stopEditingFilter();
            },
            iconType: "cross",
            "aria-label": cancelAria
          }));
        }
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          size: "s",
          onClick: () => this.startEditingFilter(filter.clientId, filter.value),
          iconType: "pencil",
          "aria-label": editAria,
          "data-test-subj": `edit_filter-${filter.value}`
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          size: "s",
          color: "danger",
          onClick: () => deleteFilter(filter),
          iconType: "trash",
          "aria-label": deleteAria
        }));
      }
    }];
  }
  render() {
    const {
      items,
      isSaving
    } = this.props;
    const columns = this.getColumns();
    const pagination = {
      initialPageSize: 10,
      pageSizeOptions: [5, 10, 25, 50]
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      loading: isSaving,
      items: items,
      columns: columns,
      pagination: pagination,
      sorting: true
    });
  }
}
exports.Table = Table;