"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistogramFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _default = require("../default/default");
var _samples = require("../../samples");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class HistogramFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ..._default.defaultState,
      sampleInputs: [50.1234, 100.0001, 99.9999, {
        values: [0.00001, 99.9999, 200, 300],
        counts: [573, 102, 482]
      }]
    });
  }
  render() {
    var _formatParams$params$, _formatParams$params;
    const {
      formatParams
    } = this.props;
    const {
      error,
      samples
    } = this.state;
    const numberOptions = [{
      value: 'number',
      text: _i18n.i18n.translate('indexPatternFieldEditor.histogram.subFormat.number', {
        defaultMessage: 'Number'
      })
    }, {
      value: 'bytes',
      text: _i18n.i18n.translate('indexPatternFieldEditor.histogram.subFormat.bytes', {
        defaultMessage: 'Bytes'
      })
    }, {
      value: 'percent',
      text: _i18n.i18n.translate('indexPatternFieldEditor.histogram.subFormat.percent', {
        defaultMessage: 'Percentage'
      })
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('indexPatternFieldEditor.histogram.histogramAsNumberLabel', {
        defaultMessage: 'Aggregated number format'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: numberOptions,
      value: formatParams.id || 'number',
      onChange: e => {
        this.onChange({
          id: e.target.value
        });
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('indexPatternFieldEditor.histogram.numeralLabel', {
        defaultMessage: 'Numeral format pattern (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: "https://adamwdraper.github.io/Numeral-js/"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.number.documentationLabel",
        defaultMessage: "Documentation"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      }))),
      isInvalid: !!error,
      error: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: (_formatParams$params$ = formatParams === null || formatParams === void 0 ? void 0 : (_formatParams$params = formatParams.params) === null || _formatParams$params === void 0 ? void 0 : _formatParams$params.pattern) !== null && _formatParams$params$ !== void 0 ? _formatParams$params$ : '',
      onChange: e => {
        this.onChange({
          params: {
            pattern: e.target.value
          }
        });
      },
      isInvalid: !!error
    })), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples
    }));
  }
}
exports.HistogramFormatEditor = HistogramFormatEditor;
(0, _defineProperty2.default)(HistogramFormatEditor, "formatId", _constants.formatId);