"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompositeEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _form_fields = require("./form_fields");
var _field_editor_context = require("../field_editor_context");
var _constants = require("./constants");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CompositeEditor = ({
  onReset
}) => {
  const {
    links,
    existingConcreteFields,
    subfields$
  } = (0, _field_editor_context.useFieldEditorContext)();
  const subfields = (0, _useObservable.default)(subfields$) || {};
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "compositeEditor"
  }, /*#__PURE__*/_react.default.createElement(_form_fields.ScriptField, {
    existingConcreteFields: existingConcreteFields,
    links: links,
    placeholder: "emit('field_name', 'hello world');"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.compositeFieldsCount",
    defaultMessage: "Generated fields"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued"
  }, Object.entries(subfields).length))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    iconType: "refresh",
    onClick: onReset
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.compositeRefreshTypes",
    defaultMessage: "Reset"
  })))), Object.entries(subfields).map(([key, itemValue], idx) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: key,
      disabled: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.runtimeType.placeholderLabel', {
        defaultMessage: 'Select a type'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: _constants.RUNTIME_FIELD_OPTIONS_PRIMITIVE,
      selectedOptions: [(0, _lib.valueToComboBoxOption)(itemValue.type)],
      onChange: newValue => {
        if (newValue.length === 0) {
          // Don't allow clearing the type. One must always be selected
          return;
        }
        // update the type for the given field
        subfields[key] = {
          type: newValue[0].value
        };
        subfields$.next({
          ...subfields
        });
      },
      isClearable: false,
      "data-test-subj": `typeField_${idx}`,
      "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.editor.form.typeSelectAriaLabel', {
        defaultMessage: 'Type select'
      }),
      fullWidth: true
    })))));
  })));
};
exports.CompositeEditor = CompositeEditor;