"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveFieldTypeOrNameChangedModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const geti18nTexts = fieldName => ({
  cancelButtonText: _i18n.i18n.translate('indexPatternFieldEditor.saveRuntimeField.confirmationModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  confirmButtonText: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmationModal.saveButtonLabel', {
    defaultMessage: 'Save changes'
  }),
  warningChangingFields: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.warningChangingFields', {
    defaultMessage: 'Changing name or type can break searches and visualizations that rely on this field.'
  }),
  typeConfirm: _i18n.i18n.translate('indexPatternFieldEditor.saveRuntimeField.confirmModal.typeConfirm', {
    defaultMessage: 'Enter CHANGE to continue'
  }),
  titleConfirmChanges: _i18n.i18n.translate('indexPatternFieldEditor.saveRuntimeField.confirmModal.title', {
    defaultMessage: `Save changes to '{name}'`,
    values: {
      name: fieldName
    }
  })
});
const SaveFieldTypeOrNameChangedModal = ({
  fieldName,
  onCancel,
  onConfirm
}) => {
  const i18nTexts = geti18nTexts(fieldName);
  const [confirmContent, setConfirmContent] = (0, _react.useState)('');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18nTexts.titleConfirmChanges,
    "data-test-subj": "runtimeFieldSaveConfirmModal",
    cancelButtonText: i18nTexts.cancelButtonText,
    confirmButtonText: i18nTexts.confirmButtonText,
    confirmButtonDisabled: (confirmContent === null || confirmContent === void 0 ? void 0 : confirmContent.toUpperCase()) !== 'CHANGE',
    onCancel: onCancel,
    onConfirm: onConfirm
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: i18nTexts.warningChangingFields,
    iconType: "warning",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18nTexts.typeConfirm
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: confirmContent,
    onChange: e => setConfirmContent(e.target.value),
    "data-test-subj": "saveModalConfirmText"
  })));
};
exports.SaveFieldTypeOrNameChangedModal = SaveFieldTypeOrNameChangedModal;