"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _form_schema = require("../form_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createNameNoDupesValidator = namesNotAllowed => ({
  validator: ({
    value
  }) => {
    if (namesNotAllowed.includes(value)) {
      return {
        message: _i18n.i18n.translate('indexPatternEditor.dataViewExists.ValidationErrorMessage', {
          defaultMessage: 'A data view with this name already exists.'
        })
      };
    }
  }
});
const getNameConfig = ({
  namesNotAllowed
}) => {
  const nameFieldConfig = _form_schema.schema.name;
  const validations = [...nameFieldConfig.validations, createNameNoDupesValidator(namesNotAllowed)];
  return {
    ...nameFieldConfig,
    validations
  };
};
const NameField = ({
  namesNotAllowed
}) => {
  const config = (0, _react.useMemo)(() => getNameConfig({
    namesNotAllowed
  }), [namesNotAllowed]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    config: config,
    componentProps: {
      euiFieldProps: {
        'aria-label': _i18n.i18n.translate('indexPatternEditor.form.nameAriaLabel', {
          defaultMessage: 'Name field optional'
        })
      }
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: field.label,
      fullWidth: true,
      error: errorMessage,
      isInvalid: isInvalid
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: field.value,
      onChange: e => {
        field.setValue(e.target.value);
      },
      fullWidth: true,
      "data-test-subj": "createIndexPatternNameInput"
    }));
  });
};
exports.NameField = NameField;