"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternEditorFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/data-views-plugin/public");
var _shared_imports = require("../shared_imports");
var _flyout_panels = require("./flyout_panels");
var _lib = require("../lib");
var _ = require(".");
var _edit_data_view_changed_modal = require("./confirm_modals/edit_data_view_changed_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const editorTitle = _i18n.i18n.translate('indexPatternEditor.title', {
  defaultMessage: 'Create data view'
});
const editorTitleEditMode = _i18n.i18n.translate('indexPatternEditor.titleEditMode', {
  defaultMessage: 'Edit data view'
});
const IndexPatternEditorFlyoutContentComponent = ({
  onSave,
  onCancel,
  defaultTypeIsRollup,
  editData,
  allowAdHoc,
  showManagementLink,
  dataViewEditorService
}) => {
  var _form$getFields$type;
  const {
    services: {
      application,
      dataViews,
      uiSettings,
      overlays
    }
  } = (0, _shared_imports.useKibana)();
  const canSave = dataViews.getCanSaveSync();
  const {
    form
  } = (0, _shared_imports.useForm)({
    // Prefill with data if editData exists
    defaultValue: {
      type: defaultTypeIsRollup ? _public.INDEX_PATTERN_TYPE.ROLLUP : _public.INDEX_PATTERN_TYPE.DEFAULT,
      isAdHoc: false,
      ...(editData ? {
        title: editData.getIndexPattern(),
        id: editData.id,
        name: editData.name,
        allowHidden: editData.getAllowHidden(),
        ...(editData.timeFieldName ? {
          timestampField: {
            label: editData.timeFieldName,
            value: editData.timeFieldName
          }
        } : {})
      } : {})
    },
    schema: _.schema,
    onSubmit: async (formData, isValid) => {
      var _formData$timestampFi;
      if (!isValid) {
        return;
      }
      const indexPatternStub = {
        title: (0, _lib.removeSpaces)(formData.title),
        timeFieldName: (_formData$timestampFi = formData.timestampField) === null || _formData$timestampFi === void 0 ? void 0 : _formData$timestampFi.value,
        id: formData.id,
        name: formData.name,
        allowHidden: formData.allowHidden
      };
      if (type === _public.INDEX_PATTERN_TYPE.ROLLUP && rollupIndex) {
        indexPatternStub.type = _public.INDEX_PATTERN_TYPE.ROLLUP;
        indexPatternStub.typeMeta = {
          params: {
            rollup_index: rollupIndex
          },
          aggs: rollupIndicesCapabilities[rollupIndex].aggs
        };
      }
      if (editData && editData.getIndexPattern() !== formData.title) {
        await (0, _edit_data_view_changed_modal.editDataViewModal)({
          dataViewName: formData.name || formData.title,
          overlays,
          onEdit: async () => {
            await onSave(indexPatternStub, !formData.isAdHoc);
          }
        });
      } else {
        await onSave(indexPatternStub, !formData.isAdHoc);
      }
    }
  });

  // `useFormData` initially returns `undefined`,
  // we override `undefined` with real default values from `schema`
  // to get a stable reference to avoid hooks re-run and reduce number of excessive requests
  const [{
    title = _.schema.title.defaultValue,
    allowHidden = _.schema.allowHidden.defaultValue,
    type = _.schema.type.defaultValue
  }] = (0, _shared_imports.useFormData)({
    form
  });
  const isLoadingSources = (0, _useObservable.default)(dataViewEditorService.isLoadingSources$, true);
  const existingDataViewNames = (0, _useObservable.default)(dataViewEditorService.dataViewNames$);
  const rollupIndex = (0, _useObservable.default)(dataViewEditorService.rollupIndex$);
  const rollupIndicesCapabilities = (0, _useObservable.default)(dataViewEditorService.rollupIndicesCaps$, {});
  (0, _useDebounce.default)(() => {
    dataViewEditorService.setIndexPattern(title);
  }, 250, [dataViewEditorService, title]);
  (0, _react.useEffect)(() => {
    dataViewEditorService.setAllowHidden(allowHidden);
  }, [dataViewEditorService, allowHidden]);
  (0, _react.useEffect)(() => {
    dataViewEditorService.setType(type);
  }, [dataViewEditorService, type]);
  const getRollupIndices = rollupCaps => Object.keys(rollupCaps);
  const onTypeChange = (0, _react.useCallback)(newType => {
    form.setFieldValue('title', '');
    form.setFieldValue('name', '');
    form.setFieldValue('timestampField', '');
    if (newType === _public.INDEX_PATTERN_TYPE.ROLLUP) {
      form.setFieldValue('allowHidden', false);
    }
  }, [form]);
  if (isLoadingSources || !existingDataViewNames) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  const showIndexPatternTypeSelect = () => uiSettings.isDeclared('rollups:enableIndexPatterns') && uiSettings.get('rollups:enableIndexPatterns') && getRollupIndices(rollupIndicesCapabilities).length;
  const indexPatternTypeSelect = showIndexPatternTypeSelect() ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.TypeField, {
    onChange: onTypeChange
  }))), type === _public.INDEX_PATTERN_TYPE.ROLLUP ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.RollupBetaWarning, null))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Group, {
    flyoutClassName: 'indexPatternEditorFlyout',
    maxWidth: 1180
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    className: "fieldEditor__mainFlyoutPanel",
    "data-test-subj": "indexPatternEditorFlyout",
    border: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, editData ? editorTitleEditMode : editorTitle)), showManagementLink && editData && editData.id && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: application.getUrlForApp('management', {
      path: `/kibana/dataViews/dataView/${editData.id}`
    })
  }, _i18n.i18n.translate('indexPatternEditor.goToManagementPage', {
    defaultMessage: 'Manage settings and view field details'
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    className: "indexPatternEditor__form",
    error: form.getErrors(),
    isInvalid: form.isSubmitted && !form.isValid && form.getErrors().length,
    "data-validation-error": form.getErrors().length ? '1' : '0',
    "data-test-subj": "indexPatternEditorForm"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "isAdHoc"
  }), indexPatternTypeSelect, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.NameField, {
    namesNotAllowed: existingDataViewNames || []
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.TitleField, {
    isRollup: ((_form$getFields$type = form.getFields().type) === null || _form$getFields$type === void 0 ? void 0 : _form$getFields$type.value) === _public.INDEX_PATTERN_TYPE.ROLLUP,
    matchedIndices$: dataViewEditorService.matchedIndices$,
    rollupIndicesCapabilities: rollupIndicesCapabilities,
    indexPatternValidationProvider: dataViewEditorService.indexPatternValidationProvider
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.TimestampField, {
    options$: dataViewEditorService.timestampFieldOptions$,
    isLoadingOptions$: dataViewEditorService.loadingTimestampFields$,
    matchedIndices$: dataViewEditorService.matchedIndices$
  }))), /*#__PURE__*/_react.default.createElement(_.AdvancedParamsContent, {
    disableAllowHidden: type === _public.INDEX_PATTERN_TYPE.ROLLUP,
    disableId: !!editData,
    onAllowHiddenChange: () => {
      form.getFields().title.validate();
    },
    defaultVisible: editData === null || editData === void 0 ? void 0 : editData.getAllowHidden()
  })), /*#__PURE__*/_react.default.createElement(_.Footer, {
    onCancel: onCancel,
    onSubmit: async adhoc => {
      const formData = form.getFormData();
      if (!formData.name) {
        form.updateFieldValues({
          name: formData.title
        });
        await form.getFields().name.validate();
      }
      // Ensures timestamp field is validated against current set of options
      form.validateFields(['timestampField']);
      form.setFieldValue('isAdHoc', adhoc || false);
      form.submit();
    },
    submitDisabled: form.isSubmitted && !form.isValid || form.isSubmitting,
    submittingType: form.isSubmitting ? form.getFormData().isAdHoc ? _.SubmittingType.savingAsAdHoc : _.SubmittingType.persisting : undefined,
    isEdit: !!editData,
    isPersisted: Boolean(editData && editData.isPersisted()),
    allowAdHoc: allowAdHoc,
    canSave: canSave
  })), /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, null, isLoadingSources ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_.PreviewPanel, {
    type: type,
    allowHidden: allowHidden,
    title: title,
    matchedIndices$: dataViewEditorService.matchedIndices$
  })));
};
const IndexPatternEditorFlyoutContent = /*#__PURE__*/_react.default.memo(IndexPatternEditorFlyoutContentComponent);
exports.IndexPatternEditorFlyoutContent = IndexPatternEditorFlyoutContent;