"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTableFormat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DataTableFormat extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "csvSeparator", this.props.uiSettings.get('csv:separator', ','));
    (0, _defineProperty2.default)(this, "quoteValues", this.props.uiSettings.get('csv:quoteValues', true));
    (0, _defineProperty2.default)(this, "state", {});
  }
  static renderCell({
    table,
    columnIndex,
    rowIndex,
    formattedValue,
    uiActions,
    isFilterable
  }) {
    const column = table.columns[columnIndex];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, formattedValue), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "none",
      alignItems: "center"
    }, isFilterable && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.filterForValueButtonTooltip",
        defaultMessage: "Filter for value"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      color: "text",
      "aria-label": _i18n.i18n.translate('data.inspector.table.filterForValueButtonAriaLabel', {
        defaultMessage: 'Filter for value'
      }),
      "data-test-subj": "filterForInspectorCellValue",
      className: "insDataTableFormat__filter",
      onClick: () => {
        const value = table.rows[rowIndex][column.id];
        const eventData = {
          table,
          column: columnIndex,
          row: rowIndex,
          value
        };
        uiActions.executeTriggerActions('VALUE_CLICK_TRIGGER', {
          data: {
            data: [eventData]
          }
        });
      }
    })), isFilterable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.filterOutValueButtonTooltip",
        defaultMessage: "Filter out value"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "text",
      "aria-label": _i18n.i18n.translate('data.inspector.table.filterOutValueButtonAriaLabel', {
        defaultMessage: 'Filter out value'
      }),
      "data-test-subj": "filterOutInspectorCellValue",
      className: "insDataTableFormat__filter",
      onClick: () => {
        const value = table.rows[rowIndex][column.id];
        const eventData = {
          table,
          column: columnIndex,
          row: rowIndex,
          value
        };
        uiActions.executeTriggerActions('VALUE_CLICK_TRIGGER', {
          data: {
            data: [eventData],
            negate: true
          }
        });
      }
    }))))));
  }
  static getDerivedStateFromProps({
    data,
    uiActions,
    fieldFormats,
    isFilterable
  }) {
    if (!data) {
      return {
        columns: null,
        rows: null
      };
    }
    const columns = data.columns.map((dataColumn, index) => {
      const formatParams = {
        id: 'string',
        ...dataColumn.meta.params
      };
      const fieldFormatter = fieldFormats.deserialize(formatParams);
      const filterable = isFilterable(dataColumn);
      return {
        name: dataColumn.name,
        field: dataColumn.id,
        sortable: true,
        render: value => {
          const formattedValue = fieldFormatter.convert(value);
          const rowIndex = data.rows.findIndex(row => row[dataColumn.id] === value) || 0;
          return DataTableFormat.renderCell({
            table: data,
            columnIndex: index,
            rowIndex,
            formattedValue,
            uiActions,
            isFilterable: filterable
          });
        }
      };
    });
    return {
      columns,
      rows: data.rows
    };
  }
  render() {
    const {
      columns,
      rows
    } = this.state;
    const pagination = {
      pageSizeOptions: [10, 20, 50],
      initialPageSize: 20
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      tableLayout: "auto",
      className: "insDataTableFormat__table eui-xScroll",
      "data-test-subj": "inspectorTable",
      columns: columns,
      items: rows,
      sorting: true,
      pagination: pagination,
      css: (0, _react2.css)`
          // Set a min width on each column - you can use [data-test-subj] to target specific columns
          .euiTableHeaderCell {
            min-width: 100px;
          }

          // Make sure the pagination follows the scroll
          > div:last-child {
            position: sticky;
            left: 0;
          }
        `
    });
  }
}
exports.DataTableFormat = DataTableFormat;
(0, _defineProperty2.default)(DataTableFormat, "propTypes", {
  data: _propTypes.default.object.isRequired,
  uiSettings: _propTypes.default.object.isRequired,
  fieldFormats: _propTypes.default.object.isRequired,
  uiActions: _propTypes.default.object.isRequired,
  isFilterable: _propTypes.default.func.isRequired
});