"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSessionsMgmtMain = SearchSessionsMgmtMain;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _table = require("./table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SearchSessionsMgmtMain({
  documentation,
  ...tableProps
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.mgmt.searchSessions.main.sectionTitle",
      defaultMessage: "Search Sessions"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.mgmt.searchSessions.main.sectionDescription",
      defaultMessage: "Manage your saved search sessions."
    }),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: documentation.getElasticsearchDocLink(),
      target: "_blank",
      iconType: "help"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.mgmt.searchSessions.main.backgroundSessionsDocsLinkText",
      defaultMessage: "Documentation"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_table.SearchSessionsMgmtTable, (0, _extends2.default)({
    "data-test-subj": "search-sessions-mgmt-table"
  }, tableProps)));
}