"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-utils-plugin/common");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EsError extends _common.KbnError {
  constructor(err, openInInspector) {
    var _getRootCause, _err$attributes;
    super(`EsError: ${((_getRootCause = (0, _utils.getRootCause)(err === null || err === void 0 ? void 0 : (_err$attributes = err.attributes) === null || _err$attributes === void 0 ? void 0 : _err$attributes.error)) === null || _getRootCause === void 0 ? void 0 : _getRootCause.reason) || _i18n.i18n.translate('data.esError.unknownRootCause', {
      defaultMessage: 'unknown'
    })}`);
    (0, _defineProperty2.default)(this, "attributes", void 0);
    this.err = err;
    this.openInInspector = openInInspector;
    this.attributes = err.attributes;
  }
  getErrorMessage() {
    var _this$attributes, _getRootCause2;
    if (!((_this$attributes = this.attributes) !== null && _this$attributes !== void 0 && _this$attributes.error)) {
      return null;
    }
    const rootCause = (_getRootCause2 = (0, _utils.getRootCause)(this.attributes.error)) === null || _getRootCause2 === void 0 ? void 0 : _getRootCause2.reason;
    const topLevelCause = this.attributes.error.reason;
    const cause = rootCause !== null && rootCause !== void 0 ? rootCause : topLevelCause;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      "data-test-subj": "errMessage",
      isCopyable: true,
      paddingSize: "s"
    }, cause));
  }
  getActions(application) {
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "viewRequestDetails",
      color: "primary",
      onClick: this.openInInspector,
      size: "s"
    }, _i18n.i18n.translate('data.esError.viewDetailsButtonLabel', {
      defaultMessage: 'View details'
    }))];
  }
}
exports.EsError = EsError;