"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embeddableServiceFactory = void 0;
var _mocks = require("@kbn/embeddable-plugin/public/mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const embeddableServiceFactory = () => {
  const pluginMock = _mocks.embeddablePluginMock.createStartContract();
  return {
    getEmbeddableFactories: pluginMock.getEmbeddableFactories,
    getEmbeddableFactory: pluginMock.getEmbeddableFactory,
    getStateTransfer: pluginMock.getStateTransfer,
    getAllMigrations: pluginMock.getAllMigrations,
    telemetry: pluginMock.telemetry,
    extract: pluginMock.extract,
    inject: pluginMock.inject
  };
};
exports.embeddableServiceFactory = embeddableServiceFactory;