"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardCapabilitiesServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardCapabilitiesServiceFactory = ({
  coreStart
}) => {
  const {
    application: {
      capabilities: {
        dashboard,
        maps,
        visualize
      }
    }
  } = coreStart;
  return {
    show: Boolean(dashboard.show),
    saveQuery: Boolean(dashboard.saveQuery),
    createNew: Boolean(dashboard.createNew),
    mapsCapabilities: {
      save: Boolean(maps === null || maps === void 0 ? void 0 : maps.save)
    },
    createShortUrl: Boolean(dashboard.createShortUrl),
    showWriteControls: Boolean(dashboard.showWriteControls),
    visualizeCapabilities: {
      save: Boolean(visualize === null || visualize === void 0 ? void 0 : visualize.save)
    },
    storeSearchSession: Boolean(dashboard.storeSearchSession)
  };
};
exports.dashboardCapabilitiesServiceFactory = dashboardCapabilitiesServiceFactory;