"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardPerformanceTracker = void 0;
var _react = require("react");
var _dashboard_container = require("../../embeddable/dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDefaultPerformanceTracker = () => ({
  panelsRenderStartTime: performance.now(),
  panelsRenderDoneTime: 0,
  lastTimeToData: 0,
  panelIds: {},
  doneCount: 0,
  status: 'done'
});
const useDashboardPerformanceTracker = ({
  panelCount
}) => {
  const dashboard = (0, _dashboard_container.useDashboardContainer)();

  // reset performance tracker on each render.
  const performanceRefs = (0, _react.useRef)(getDefaultPerformanceTracker());
  performanceRefs.current = getDefaultPerformanceTracker();
  const onPanelStatusChange = (0, _react.useCallback)(info => {
    if (performanceRefs.current.panelIds[info.id] === undefined || info.status === 'loading') {
      performanceRefs.current.panelIds[info.id] = {};
    } else if (info.status === 'error') {
      performanceRefs.current.status = 'error';
    } else if (info.status === 'loaded') {
      performanceRefs.current.lastTimeToData = performance.now();
    }
    performanceRefs.current.panelIds[info.id][info.status] = performance.now();
    if (info.status === 'error' || info.status === 'rendered') {
      performanceRefs.current.doneCount++;
      if (performanceRefs.current.doneCount === panelCount) {
        performanceRefs.current.panelsRenderDoneTime = performance.now();
        dashboard.reportPerformanceMetrics(performanceRefs.current);
      }
    }
  }, [dashboard, panelCount]);
  return {
    onPanelStatusChange
  };
};
exports.useDashboardPerformanceTracker = useDashboardPerformanceTracker;