"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanEmptyKeys = exports.DashboardAppLocatorDefinition = exports.DASHBOARD_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _dashboard_constants = require("../../dashboard_constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/**
 * Useful for ensuring that we don't pass any non-serializable values to history.push (for example, functions).
 */
const getSerializableRecord = (0, _lodash.flow)(JSON.stringify, JSON.parse);
const cleanEmptyKeys = stateObj => {
  Object.keys(stateObj).forEach(key => {
    if (stateObj[key] === undefined) {
      delete stateObj[key];
    }
  });
  return stateObj;
};
exports.cleanEmptyKeys = cleanEmptyKeys;
const DASHBOARD_APP_LOCATOR = 'DASHBOARD_APP_LOCATOR';
exports.DASHBOARD_APP_LOCATOR = DASHBOARD_APP_LOCATOR;
class DashboardAppLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", DASHBOARD_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        filters,
        useHash: paramsUseHash,
        preserveSavedFilters,
        dashboardId,
        ...restParams
      } = params;
      const useHash = paramsUseHash !== null && paramsUseHash !== void 0 ? paramsUseHash : this.deps.useHashedUrl;
      const hash = dashboardId ? `view/${dashboardId}` : `create`;
      const getSavedFiltersFromDestinationDashboardIfNeeded = async () => {
        if (preserveSavedFilters === false) return [];
        if (!params.dashboardId) return [];
        try {
          return await this.deps.getDashboardFilterFields(params.dashboardId);
        } catch (e) {
          // In case dashboard is missing, build the url without those filters.
          // The Dashboard app will handle redirect to landing page with a toast message.
          return [];
        }
      };
      const state = restParams;

      // leave filters `undefined` if no filters was applied
      // in this case dashboard will restore saved filters on its own
      state.filters = params.filters && [...(await getSavedFiltersFromDestinationDashboardIfNeeded()), ...params.filters];
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      let path = `#/${hash}`;
      path = (0, _public.setStateToKbnUrl)('_g', cleanEmptyKeys({
        time: params.timeRange,
        filters: filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f)),
        refreshInterval: params.refreshInterval
      }), {
        useHash
      }, path);
      if (params.searchSessionId) {
        path = `${path}&${_dashboard_constants.SEARCH_SESSION_ID}=${params.searchSessionId}`;
      }
      return {
        app: _dashboard_constants.DASHBOARD_APP_ID,
        path,
        state: getSerializableRecord(cleanEmptyKeys(state))
      };
    });
    this.deps = deps;
  }
}
exports.DashboardAppLocatorDefinition = DashboardAppLocatorDefinition;