"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardLocatorParamsFromEmbeddable = void 0;
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDashboardLocatorParamsFromEmbeddable = (source, options) => {
  var _input$filters;
  const params = {};
  const input = source.getInput();
  if ((0, _common.isQuery)(input.query) && options.useCurrentFilters) {
    params.query = input.query;
  }

  // if useCurrentDashboardDataRange is enabled, then preserve current time range
  // if undefined is passed, then destination dashboard will figure out time range itself
  // for brush event this time range would be overwritten
  if ((0, _common.isTimeRange)(input.timeRange) && options.useCurrentDateRange) {
    params.timeRange = input.timeRange;
  }

  // if useCurrentDashboardFilters enabled, then preserve all the filters (pinned, unpinned, and from controls)
  // otherwise preserve only pinned
  params.filters = options.useCurrentFilters ? input.filters : (_input$filters = input.filters) === null || _input$filters === void 0 ? void 0 : _input$filters.filter(f => (0, _esQuery.isFilterPinned)(f));
  return params;
};
exports.getDashboardLocatorParamsFromEmbeddable = getDashboardLocatorParamsFromEmbeddable;