"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnlinkFromLibraryAction = exports.ACTION_UNLINK_FROM_LIBRARY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _dashboard_container = require("../dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_UNLINK_FROM_LIBRARY = 'unlinkFromLibrary';
exports.ACTION_UNLINK_FROM_LIBRARY = ACTION_UNLINK_FROM_LIBRARY;
class UnlinkFromLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_UNLINK_FROM_LIBRARY);
    (0, _defineProperty2.default)(this, "id", ACTION_UNLINK_FROM_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 15);
    (0, _defineProperty2.default)(this, "toastsService", void 0);
    ({
      notifications: {
        toasts: this.toastsService
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return 'folderExclamation';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$getInput;
    return Boolean(!(0, _public.isErrorEmbeddable)(embeddable) && ((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== _public.ViewMode.VIEW && embeddable.getRoot() && embeddable.getRoot().isContainer && embeddable.getRoot().type === _dashboard_container.DASHBOARD_CONTAINER_TYPE && (0, _public.isReferenceOrValueEmbeddable)(embeddable) && embeddable.inputIsRefType(embeddable.getInput()));
  }
  async execute({
    embeddable
  }) {
    if (!(0, _public.isReferenceOrValueEmbeddable)(embeddable)) {
      throw new _public2.IncompatibleActionError();
    }
    const newInput = await embeddable.getInputAsValueType();
    embeddable.updateInput(newInput);
    const dashboard = embeddable.getRoot();
    const panelToReplace = dashboard.getInput().panels[embeddable.id];
    if (!panelToReplace) {
      throw new _public.PanelNotFoundError();
    }
    const newPanel = {
      type: embeddable.type,
      explicitInput: {
        ...newInput,
        title: embeddable.getTitle()
      }
    };
    const replacedPanelId = await dashboard.replacePanel(panelToReplace, newPanel, true);
    const title = _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getSuccessMessage(embeddable.getTitle() ? `'${embeddable.getTitle()}'` : '');
    if (dashboard.getExpandedPanelId() !== undefined) {
      dashboard.setExpandedPanelId(replacedPanelId);
    }
    this.toastsService.addSuccess({
      title,
      'data-test-subj': 'unlinkPanelSuccess'
    });
  }
}
exports.UnlinkFromLibraryAction = UnlinkFromLibraryAction;