"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildAllDashboardActions = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/saved-objects-finder-plugin/public");
var _export_csv_action = require("./export_csv_action");
var _clone_panel_action = require("./clone_panel_action");
var _expand_panel_action = require("./expand_panel_action");
var _replace_panel_action = require("./replace_panel_action");
var _add_to_library_action = require("./add_to_library_action");
var _copy_to_dashboard_action = require("./copy_to_dashboard_action");
var _unlink_from_library_action = require("./unlink_from_library_action");
var _filters_notification_action = require("./filters_notification_action");
var _library_notification_action = require("./library_notification_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildAllDashboardActions = async ({
  core,
  plugins,
  allowByValueEmbeddables
}) => {
  const {
    uiActions,
    share,
    savedObjectsTaggingOss,
    contentManagement
  } = plugins;
  const clonePanelAction = new _clone_panel_action.ClonePanelAction();
  uiActions.registerAction(clonePanelAction);
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, clonePanelAction.id);
  const SavedObjectFinder = (0, _public2.getSavedObjectFinder)(contentManagement.client, core.uiSettings, savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi());
  const changeViewAction = new _replace_panel_action.ReplacePanelAction(SavedObjectFinder);
  uiActions.registerAction(changeViewAction);
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, changeViewAction.id);
  const expandPanelAction = new _expand_panel_action.ExpandPanelAction();
  uiActions.registerAction(expandPanelAction);
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, expandPanelAction.id);
  const panelLevelFiltersNotificationAction = new _filters_notification_action.FiltersNotificationAction();
  uiActions.registerAction(panelLevelFiltersNotificationAction);
  uiActions.attachAction(_public.PANEL_NOTIFICATION_TRIGGER, panelLevelFiltersNotificationAction.id);
  if (share) {
    const ExportCSVPlugin = new _export_csv_action.ExportCSVAction();
    uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, ExportCSVPlugin);
  }
  if (allowByValueEmbeddables) {
    const addToLibraryAction = new _add_to_library_action.AddToLibraryAction();
    uiActions.registerAction(addToLibraryAction);
    uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, addToLibraryAction.id);
    const unlinkFromLibraryAction = new _unlink_from_library_action.UnlinkFromLibraryAction();
    uiActions.registerAction(unlinkFromLibraryAction);
    uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, unlinkFromLibraryAction.id);
    const libraryNotificationAction = new _library_notification_action.LibraryNotificationAction(unlinkFromLibraryAction);
    uiActions.registerAction(libraryNotificationAction);
    uiActions.attachAction(_public.PANEL_NOTIFICATION_TRIGGER, libraryNotificationAction.id);
    const copyToDashboardAction = new _copy_to_dashboard_action.CopyToDashboardAction(core);
    uiActions.registerAction(copyToDashboardAction);
    uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, copyToDashboardAction.id);
  }
};
exports.buildAllDashboardActions = buildAllDashboardActions;