"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractReferences = extractReferences;
exports.injectReferences = injectReferences;
var _common = require("@kbn/controls-plugin/common");
var _dashboard_panel_converters = require("../../lib/dashboard_panel_converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function parseDashboardAttributesWithType(attributes) {
  let parsedPanels = [];
  if (typeof attributes.panelsJSON === 'string') {
    const parsedJSON = JSON.parse(attributes.panelsJSON);
    if (Array.isArray(parsedJSON)) {
      parsedPanels = parsedJSON;
    }
  }
  return {
    controlGroupInput: attributes.controlGroupInput && (0, _common.rawControlGroupAttributesToControlGroupInput)(attributes.controlGroupInput),
    type: 'dashboard',
    panels: (0, _dashboard_panel_converters.convertSavedPanelsToPanelMap)(parsedPanels)
  };
}
function injectReferences({
  attributes,
  references = []
}, deps) {
  const parsedAttributes = parseDashboardAttributesWithType(attributes);

  // inject references back into panels via the Embeddable persistable state service.
  const injectedState = deps.embeddablePersistableStateService.inject(parsedAttributes, references);
  const injectedPanels = (0, _dashboard_panel_converters.convertPanelMapToSavedPanels)(injectedState.panels);
  const newAttributes = {
    ...attributes,
    panelsJSON: JSON.stringify(injectedPanels)
  };
  if (attributes.controlGroupInput && injectedState.controlGroupInput) {
    newAttributes.controlGroupInput = {
      ...attributes.controlGroupInput,
      panelsJSON: JSON.stringify(injectedState.controlGroupInput.panels)
    };
  }
  return newAttributes;
}
function extractReferences({
  attributes,
  references = []
}, deps) {
  const parsedAttributes = parseDashboardAttributesWithType(attributes);
  const panels = parsedAttributes.panels;
  const panelMissingType = Object.values(panels).find(panel => panel.type === undefined);
  if (panelMissingType) {
    throw new Error(`"type" attribute is missing from panel "${panelMissingType.explicitInput.id}"`);
  }
  const {
    references: extractedReferences,
    state: extractedState
  } = deps.embeddablePersistableStateService.extract(parsedAttributes);
  const extractedPanels = (0, _dashboard_panel_converters.convertPanelMapToSavedPanels)(extractedState.panels);
  const newAttributes = {
    ...attributes,
    panelsJSON: JSON.stringify(extractedPanels)
  };
  if (attributes.controlGroupInput && extractedState.controlGroupInput) {
    newAttributes.controlGroupInput = {
      ...attributes.controlGroupInput,
      panelsJSON: JSON.stringify(extractedState.controlGroupInput.panels)
    };
  }
  return {
    references: [...references, ...extractedReferences],
    attributes: newAttributes
  };
}