"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enhanceEmbeddable = exports.MockEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-enhanced-plugin/public");
var _mocks = require("@kbn/ui-actions-enhanced-plugin/public/mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MockEmbeddable extends _public.Embeddable {
  constructor(initialInput, params) {
    var _params$supportedTrig;
    super(initialInput, {}, undefined);
    (0, _defineProperty2.default)(this, "rootType", 'dashboard');
    (0, _defineProperty2.default)(this, "type", 'mock');
    (0, _defineProperty2.default)(this, "triggers", []);
    this.triggers = (_params$supportedTrig = params.supportedTriggers) !== null && _params$supportedTrig !== void 0 ? _params$supportedTrig : [];
  }
  render(node) {}
  reload() {}
  supportedTriggers() {
    return this.triggers;
  }
  getRoot() {
    return {
      type: this.rootType
    };
  }
}
exports.MockEmbeddable = MockEmbeddable;
const enhanceEmbeddable = (embeddable, uiActions = _mocks.uiActionsEnhancedPluginMock.createStartContract()) => {
  embeddable.enhancements = {
    dynamicActions: new _public2.UiActionsEnhancedDynamicActionManager({
      storage: new _public2.UiActionsEnhancedMemoryActionStorage(),
      isCompatible: async () => true,
      uiActions
    })
  };
  return embeddable;
};
exports.enhanceEmbeddable = enhanceEmbeddable;