"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.platformServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A type definition for a factory to produce the `CustomIntegrationsPlatformService` for use in Kibana.
 */

/**
 * A factory to produce the `CustomIntegrationsPlatformService` for use in Kibana.
 */
const platformServiceFactory = ({
  coreStart
}) => ({
  getBasePath: coreStart.http.basePath.get,
  getAbsolutePath: path => coreStart.http.basePath.prepend(`${path}`)
});
exports.platformServiceFactory = platformServiceFactory;