"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routing = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = require("query-string");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file based on guidance from https://github.com/elastic/eui/blob/master/wiki/react-router.md
 */

const queryParamsFromObject = (params, encodeParams = false) => {
  if (!params) {
    return;
  }
  const paramsStr = (0, _queryString.stringify)(params, {
    sort: false,
    encode: encodeParams
  });
  return `?${paramsStr}`;
};
class Routing {
  constructor() {
    (0, _defineProperty2.default)(this, "_reactRouter", null);
    (0, _defineProperty2.default)(this, "getAutoFollowPatternPath", (name, section = '/edit') => {
      return encodeURI(`/auto_follow_patterns${section}/${encodeURIComponent(name)}`);
    });
    (0, _defineProperty2.default)(this, "getFollowerIndexPath", (name, section = '/edit') => {
      return encodeURI(`/follower_indices${section}/${encodeURIComponent(name)}`);
    });
  }
  getHrefToRemoteClusters(route = '/', params, encodeParams = false) {
    const search = queryParamsFromObject(params, encodeParams) || '';
    return this._reactRouter.getUrlForApp('management', {
      path: `${_constants.BASE_PATH_REMOTE_CLUSTERS}${route}${search}`
    });
  }
  navigate(route = '/home', params, encodeParams = false) {
    const search = queryParamsFromObject(params, encodeParams);
    this._reactRouter.history.push({
      pathname: encodeURI(route),
      search
    });
  }
  get reactRouter() {
    return this._reactRouter;
  }
  set reactRouter(router) {
    this._reactRouter = router;
  }
}
const routing = new Routing();
exports.routing = routing;