"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrossClusterReplicationHome = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _routing = require("../../services/routing");
var _auto_follow_pattern_list = require("./auto_follow_pattern_list");
var _follower_indices_list = require("./follower_indices_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CrossClusterReplicationHome extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      activeSection: 'follower_indices'
    });
    (0, _defineProperty2.default)(this, "tabs", [{
      id: 'follower_indices',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.followerIndicesTitle",
        defaultMessage: "Follower indices"
      }),
      testSubj: 'followerIndicesTab'
    }, {
      id: 'auto_follow_patterns',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.autoFollowPatternsTitle",
        defaultMessage: "Auto-follow patterns"
      }),
      testSubj: 'autoFollowPatternsTab'
    }]);
    (0, _defineProperty2.default)(this, "onSectionChange", section => {
      (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)(`/${section}`)]);
      _routing.routing.navigate(`/${section}`);
    });
  }
  componentDidMount() {
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)()]);
  }
  static getDerivedStateFromProps(props) {
    const {
      match: {
        params: {
          section
        }
      }
    } = props;
    return {
      activeSection: section
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "appTitle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.crossClusterReplicationTitle",
        defaultMessage: "Cross-Cluster Replication"
      })),
      tabs: this.tabs.map(tab => ({
        onClick: () => this.onSectionChange(tab.id),
        isSelected: tab.id === this.state.activeSection,
        key: tab.id,
        'data-test-subj': tab.testSubj,
        label: tab.name
      }))
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: `/follower_indices`,
      component: _follower_indices_list.FollowerIndicesList
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: `/auto_follow_patterns`,
      component: _auto_follow_pattern_list.AutoFollowPatternList
    })));
  }
}
exports.CrossClusterReplicationHome = CrossClusterReplicationHome;