"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFields = exports.FormEntryRow = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * State transitions: fields update
 */
const updateFields = newValues => ({
  fields
}) => ({
  fields: {
    ...fields,
    ...newValues
  }
});
exports.updateFields = updateFields;
class FormEntryRow extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onFieldChange", value => {
      const {
        field,
        onValueUpdate,
        type
      } = this.props;
      const isNumber = type === 'number';
      let valueParsed = value;
      if (isNumber) {
        valueParsed = !!value ? Math.max(0, parseInt(value, 10)) : value; // make sure we don't send NaN value or a negative number
      }

      onValueUpdate({
        [field]: valueParsed
      });
    });
    (0, _defineProperty2.default)(this, "renderField", isInvalid => {
      const {
        value,
        type,
        disabled,
        isLoading,
        testSubj
      } = this.props;
      switch (type) {
        case 'number':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
            isInvalid: isInvalid,
            value: value,
            onChange: e => this.onFieldChange(e.target.value),
            disabled: disabled === true,
            isLoading: isLoading,
            fullWidth: true,
            "data-test-subj": testSubj
          });
        default:
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
            isInvalid: isInvalid,
            value: value,
            onChange: e => this.onFieldChange(e.target.value),
            disabled: disabled === true,
            isLoading: isLoading,
            fullWidth: true,
            "data-test-subj": testSubj
          });
      }
    });
  }
  render() {
    const {
      field,
      error,
      title,
      label,
      description,
      helpText,
      areErrorsVisible,
      value,
      defaultValue
    } = this.props;
    const hasError = !!error;
    const isInvalid = hasError && (error.alwaysVisible || areErrorsVisible);
    const canBeResetToDefault = defaultValue !== undefined;
    const isResetToDefaultVisible = value !== defaultValue;
    const fieldHelpText = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, helpText, canBeResetToDefault && isResetToDefaultVisible && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => this.onFieldChange(defaultValue)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.resetFieldButtonLabel",
      defaultMessage: "Reset to default"
    }))));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: title,
      description: description,
      fullWidth: true,
      key: field
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      helpText: fieldHelpText,
      error: error && error.message ? error.message : error,
      isInvalid: isInvalid,
      fullWidth: true
    }, this.renderField(isInvalid)));
  }
}
exports.FormEntryRow = FormEntryRow;
(0, _defineProperty2.default)(FormEntryRow, "propTypes", {
  title: _propTypes.default.node,
  description: _propTypes.default.node,
  label: _propTypes.default.node,
  helpText: _propTypes.default.node,
  type: _propTypes.default.string,
  onValueUpdate: _propTypes.default.func.isRequired,
  field: _propTypes.default.string.isRequired,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired,
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  isLoading: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.object]),
  disabled: _propTypes.default.bool,
  areErrorsVisible: _propTypes.default.bool.isRequired,
  testSubj: _propTypes.default.string
});