"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiSettingsClientFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ui_settings_client = require("./ui_settings_client");
var _ui_settings_global_client = require("./ui_settings_global_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UiSettingsClientFactory {}
exports.UiSettingsClientFactory = UiSettingsClientFactory;
(0, _defineProperty2.default)(UiSettingsClientFactory, "create", options => {
  switch (options.type) {
    case 'config':
      return new _ui_settings_client.UiSettingsClient(options);
    case 'config-global':
      return new _ui_settings_global_client.UiSettingsGlobalClient(options);
    default:
      throw new Error('Unsupported client error');
  }
});