"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildMigratorConfigs = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildMigratorConfigs = ({
  typeRegistry,
  kibanaIndexPrefix
}) => {
  const configMap = new Map();
  typeRegistry.getAllTypes().forEach(type => {
    var _type$indexPattern;
    const typeIndexPrefix = (_type$indexPattern = type.indexPattern) !== null && _type$indexPattern !== void 0 ? _type$indexPattern : kibanaIndexPrefix;
    if (!configMap.has(typeIndexPrefix)) {
      configMap.set(typeIndexPrefix, {
        indexPrefix: typeIndexPrefix,
        types: []
      });
    }
    const migratorConfig = configMap.get(typeIndexPrefix);
    migratorConfig.types.push(type.name);
  });
  return [...configMap.values()];
};
exports.buildMigratorConfigs = buildMigratorConfigs;