"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForDeleteByQueryTask = void 0;
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var Option = _interopRequireWildcard(require("fp-ts/lib/Option"));
var _function = require("fp-ts/lib/function");
var _wait_for_task = require("./wait_for_task");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

const waitForDeleteByQueryTask = (0, _function.flow)(_wait_for_task.waitForTask, TaskEither.chainW(res => {
  var _res$response;
  if (Option.isSome(res.failures) || (_res$response = res.response) !== null && _res$response !== void 0 && _res$response.version_conflicts) {
    var _res$response2;
    return TaskEither.left({
      type: 'cleanup_failed',
      failures: Option.isSome(res.failures) ? res.failures.value : [],
      versionConflicts: (_res$response2 = res.response) === null || _res$response2 === void 0 ? void 0 : _res$response2.version_conflicts
    });
  } else if (Option.isSome(res.error)) {
    throw new Error('waitForDeleteByQueryTask task failed with the following error:\n' + JSON.stringify(res.error.value));
  } else {
    var _res$response3;
    return TaskEither.right({
      type: 'cleanup_successful',
      deleted: (_res$response3 = res.response) === null || _res$response3 === void 0 ? void 0 : _res$response3.deleted
    });
  }
}));
exports.waitForDeleteByQueryTask = waitForDeleteByQueryTask;