"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Core internal implementation of {@link SavedObjectsClientContract}
 * @internal
 */
class SavedObjectsClient {
  /** @internal */
  constructor(repository) {
    (0, _defineProperty2.default)(this, "errors", _coreSavedObjectsServer.SavedObjectsErrorHelpers);
    (0, _defineProperty2.default)(this, "_repository", void 0);
    this._repository = repository;
  }

  /** {@inheritDoc SavedObjectsClientContract.create} */
  async create(type, attributes, options) {
    return await this._repository.create(type, attributes, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.bulkCreate} */
  async bulkCreate(objects, options) {
    return await this._repository.bulkCreate(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.checkConflicts} */
  async checkConflicts(objects = [], options = {}) {
    return await this._repository.checkConflicts(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.delete} */
  async delete(type, id, options = {}) {
    return await this._repository.delete(type, id, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.bulkDelete} */
  async bulkDelete(objects, options = {}) {
    return await this._repository.bulkDelete(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.find} */
  async find(options) {
    return await this._repository.find(options);
  }

  /** {@inheritDoc SavedObjectsClientContract.bulkGet} */
  async bulkGet(objects = [], options = {}) {
    return await this._repository.bulkGet(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.get} */
  async get(type, id, options = {}) {
    return await this._repository.get(type, id, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.bulkResolve} */
  async bulkResolve(objects, options) {
    return await this._repository.bulkResolve(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.resolve} */
  async resolve(type, id, options = {}) {
    return await this._repository.resolve(type, id, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.update} */
  async update(type, id, attributes, options = {}) {
    return await this._repository.update(type, id, attributes, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.bulkUpdate} */
  async bulkUpdate(objects, options) {
    return await this._repository.bulkUpdate(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.removeReferencesTo} */
  async removeReferencesTo(type, id, options) {
    return await this._repository.removeReferencesTo(type, id, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.openPointInTimeForType} */
  async openPointInTimeForType(type, options = {}) {
    return await this._repository.openPointInTimeForType(type, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.closePointInTime} */
  async closePointInTime(id, options) {
    return await this._repository.closePointInTime(id, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.createPointInTimeFinder} */
  createPointInTimeFinder(findOptions, dependencies) {
    return this._repository.createPointInTimeFinder(findOptions, {
      client: this,
      // Include dependencies last so that SO client wrappers have their settings applied.
      ...dependencies
    });
  }

  /** {@inheritDoc SavedObjectsClientContract.collectMultiNamespaceReferences} */
  async collectMultiNamespaceReferences(objects, options) {
    return await this._repository.collectMultiNamespaceReferences(objects, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.updateObjectsSpaces} */
  async updateObjectsSpaces(objects, spacesToAdd, spacesToRemove, options) {
    return await this._repository.updateObjectsSpaces(objects, spacesToAdd, spacesToRemove, options);
  }

  /** {@inheritDoc SavedObjectsClientContract.getCurrentNamespace} */
  getCurrentNamespace() {
    return this._repository.getCurrentNamespace();
  }
}
exports.SavedObjectsClient = SavedObjectsClient;
(0, _defineProperty2.default)(SavedObjectsClient, "errors", _coreSavedObjectsServer.SavedObjectsErrorHelpers);