"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidRequest = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isValidRequest = ({
  allowedTypes,
  type,
  id
}) => {
  return !id ? {
    validRequest: false,
    error: _coreSavedObjectsServer.SavedObjectsErrorHelpers.createBadRequestError('id cannot be empty')
  } : !allowedTypes.includes(type) ? {
    validRequest: false,
    error: _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundError(type, id)
  } : {
    validRequest: true
  };
};
exports.isValidRequest = isValidRequest;