"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.opsConfig = exports.OPS_CONFIG_PATH = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
const OPS_CONFIG_PATH = 'ops';

/** @internal */
exports.OPS_CONFIG_PATH = OPS_CONFIG_PATH;
const OPS_METRICS_INTERVAL = '5s';

/** @internal */

/** @internal */

const configSchema = _configSchema.schema.object({
  interval: _configSchema.schema.duration({
    defaultValue: OPS_METRICS_INTERVAL
  }),
  cGroupOverrides: _configSchema.schema.object({
    cpuPath: _configSchema.schema.maybe(_configSchema.schema.string()),
    cpuAcctPath: _configSchema.schema.maybe(_configSchema.schema.string())
  })
});
const opsConfig = {
  path: OPS_CONFIG_PATH,
  schema: configSchema
};
exports.opsConfig = opsConfig;