"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsCgroupMetricsCollector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _v = require("./v1");
var _v2 = require("./v2");
var _gather_info = require("./gather_info");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class OsCgroupMetricsCollector {
  /**  Used to prevent unnecessary file reads on systems not using cgroups. */

  /** Are resources being managed by cgroup2? */

  constructor(options) {
    (0, _defineProperty2.default)(this, "noCgroupPresent", false);
    (0, _defineProperty2.default)(this, "isCgroup2", false);
    (0, _defineProperty2.default)(this, "cpuPath", void 0);
    (0, _defineProperty2.default)(this, "cpuAcctPath", void 0);
    this.options = options;
  }
  async collect() {
    try {
      if (this.noCgroupPresent) {
        return {};
      }
      await this.initializePaths();
      if (!this.hasPaths()) {
        return {};
      }

      // "await" to handle any errors here.
      return await (this.isCgroup2 ? (0, _v2.gatherV2CgroupMetrics)(this.cpuAcctPath) : (0, _v.gatherV1CgroupMetrics)({
        cpuAcctPath: this.cpuAcctPath,
        cpuPath: this.cpuPath
      }));
    } catch (err) {
      this.noCgroupPresent = true;
      if (err.code !== 'ENOENT') {
        this.options.logger.error(`cgroup metrics could not be read due to error: [${err.toString()}]`);
      }
      return {};
    }
  }
  reset() {}
  hasPaths() {
    return Boolean(this.cpuPath && this.cpuAcctPath);
  }
  async initializePaths() {
    if (this.hasPaths()) return;
    const result = await (0, _gather_info.gatherInfo)();
    this.isCgroup2 = result.v2;
    if (result.v2) {
      this.cpuPath = result.path;
      this.cpuAcctPath = result.path;
    } else {
      this.cpuPath = this.options.cpuPath || result.data[_constants.GROUP_CPU];
      this.cpuAcctPath = this.options.cpuAcctPath || result.data[_constants.GROUP_CPUACCT];
    }

    // prevents undefined cgroup paths
    this.noCgroupPresent = Boolean(!this.cpuPath || !this.cpuAcctPath);
  }
}
exports.OsCgroupMetricsCollector = OsCgroupMetricsCollector;