"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Status indicating an outcome of the authentication.
 * @public
 */
let AuthStatus;
/**
 * Gets authentication state for a request. Returned by `auth` interceptor.
 * @param request {@link KibanaRequest} - an incoming request.
 * @public
 */
exports.AuthStatus = AuthStatus;
(function (AuthStatus) {
  AuthStatus["authenticated"] = "authenticated";
  AuthStatus["unauthenticated"] = "unauthenticated";
  AuthStatus["unknown"] = "unknown";
})(AuthStatus || (exports.AuthStatus = AuthStatus = {}));
/**
 * Returns authentication status for a request.
 * @param request {@link KibanaRequest} - an incoming request.
 * @public
 */