"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
var _validator = require("../validator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** Will throw if any of the validation checks fail */
function validate(data, runtimeSchema, version) {
  const validator = _validator.RouteValidator.from(runtimeSchema);
  return {
    params: validator.getParams(data.params, 'request params'),
    query: validator.getQuery(data.query, 'request query'),
    body: validator.getBody(data.body, 'request body')
  };
}