"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchCapabilities = exports.getCapabilitiesFromClient = void 0;
var _rxjs = require("rxjs");
var _get_cluster_info = require("./get_cluster_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SERVERLESS_BUILD_FLAVOR = 'serverless';
const getElasticsearchCapabilities = ({
  clusterInfo
}) => {
  const buildFlavor = clusterInfo.cluster_build_flavor;
  return {
    serverless: buildFlavor === SERVERLESS_BUILD_FLAVOR
  };
};

/**
 * Returns the capabilities for the ES cluster the provided client is connected to.
 *
 * @internal
 */
exports.getElasticsearchCapabilities = getElasticsearchCapabilities;
const getCapabilitiesFromClient = async client => {
  const clusterInfo = await (0, _rxjs.firstValueFrom)((0, _get_cluster_info.getClusterInfo$)(client));
  return getElasticsearchCapabilities({
    clusterInfo
  });
};
exports.getCapabilitiesFromClient = getCapabilitiesFromClient;