"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentsSocketsStats = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getAgentsSocketsStats = agents => {
  const nodes = new Set();
  let totalActiveSockets = 0;
  let totalIdleSockets = 0;
  let totalQueuedRequests = 0;
  agents.forEach(agent => {
    var _Object$entries, _Object$entries2, _Object$entries3;
    const agentRequests = (_Object$entries = Object.entries(agent.requests)) !== null && _Object$entries !== void 0 ? _Object$entries : [];
    const agentSockets = (_Object$entries2 = Object.entries(agent.sockets)) !== null && _Object$entries2 !== void 0 ? _Object$entries2 : [];
    const agentFreeSockets = (_Object$entries3 = Object.entries(agent.freeSockets)) !== null && _Object$entries3 !== void 0 ? _Object$entries3 : [];
    if (agentRequests.length || agentSockets.length || agentFreeSockets.length) {
      agentRequests.forEach(([node, queue]) => {
        var _queue$length;
        nodes.add(node);
        totalQueuedRequests += (_queue$length = queue === null || queue === void 0 ? void 0 : queue.length) !== null && _queue$length !== void 0 ? _queue$length : 0;
      });
      agentSockets.forEach(([node, sockets]) => {
        var _sockets$length;
        nodes.add(node);
        const activeSockets = (_sockets$length = sockets === null || sockets === void 0 ? void 0 : sockets.length) !== null && _sockets$length !== void 0 ? _sockets$length : 0;
        totalActiveSockets += activeSockets;
      });
      agentFreeSockets.forEach(([node, freeSockets]) => {
        var _freeSockets$length;
        nodes.add(node);
        const idleSockets = (_freeSockets$length = freeSockets === null || freeSockets === void 0 ? void 0 : freeSockets.length) !== null && _freeSockets$length !== void 0 ? _freeSockets$length : 0;
        totalIdleSockets += idleSockets;
      });
    }
  });
  return {
    totalActiveSockets,
    totalIdleSockets,
    totalQueuedRequests
  };
};
exports.getAgentsSocketsStats = getAgentsSocketsStats;